<?php
$this->session = \Config\Services::session();
if ($this->session->get('__user_id')) {
    $forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?> Application</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('application-new_application', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');

    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body style="margin:0px;">
    <?php echo view("addons/".($this->session->get('__user_id')? 'secure_header': 'public_header'), array('page'=>'new_account'));?>
    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <?php
                        if ($this->session->get('__user_id')) {?>
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu"); ?>
            </nav>
            <?php } else {
                              echo "
                              <nav id='menucontainer' class='nav flex-column'>
                <?php echo view('addons/menu'); ?>
            </nav>

                                ";
                          }
                          ?>
        </aside>
        <main class="app-area-content p-3 pt-5 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?>
                                        User</h3>
                                        <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>

            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="user_data" method="post" autocomplete="off"
                                            action="<?php echo base_url().'/Register/step_one'.(!empty($id)? '/id/'.$id: '');?>"
                                            class='simplevalidator'>
                                            <table border="0" cellspacing="0" cellpadding="10" <?php if (!$this->session->get('__user_id')) {
              echo "align='center'";
          }?>>

                                                <tr>
                                                    <td class="label">Role:</td>
                                                    <td style="padding-right:42px;"><?php if (!empty($id) && $this->session->get('role__roles') || (!empty($action) && $action=='view')) {
              echo "<div class='value'>".$this->session->get('role__roles')."</div>";
          } else {?><input type="text" id="role__roles" name="role__roles" title="Select Role"
                                                            placeholder="Select User Role" class="textfield selectfield"
                                                            value="<?php echo $this->session->get('role__roles');?>"
                                                            style="width:97%;" /><?php }?></td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Surname:</td>
                                                    <td><?php if (!empty($action) && $action=='view') {
              echo "<div class='value'>".$this->session->get('lastname')."</div>";
          } else {?><input type="text" id="lastname" name="lastname" title="Surname" class="textfield"
                                                            style="width:97%;"
                                                            value="<?php echo $this->session->get('lastname');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Other Names:</td>
                                                    <td><?php if (!empty($action) && $action=='view') {
              echo "<div class='value'>".$this->session->get('firstname')."</div>";
          } else {?><input type="text" id="firstname" name="firstname" title="Other Names" class="textfield"
                                                            style="width:97%;"
                                                            value="<?php echo $this->session->get('firstname');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label top">Email Address:</td>
                                                    <td><?php if (!empty($id) && $this->session->get('emailaddress') || (!empty($action) && $action=='view')) {
              echo "<div class='value'>".$this->session->get('emailaddress')."</div>";
          } else {?><input type="text" id="emailaddress" name="emailaddress" title="Email Address" class="textfield"
                                                            style="width:97%;"
                                                            value="<?php echo $this->session->get('emailaddress');?>" /><br><span
                                                            class="smalltext">The password will be automatically
                                                            generated <br>and sent to this email
                                                            address.</span><?php }?></td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Telephone:</td>
                                                    <td><?php if (!empty($action) && $action=='view') {
              echo "<div class='value'>".$this->session->get('telephone')."</div>";
          } else {?><input type="text" id="telephone" name="telephone" title="Telephone" placeholder="e.g. 0782123456"
                                                            maxlength="10" class="textfield numbersonly telephone"
                                                            style="width:97%;"
                                                            value="<?php echo $this->session->get('telephone');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <?php if (!(!empty($action) && $action=='view')) {?>
                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td><input type="submit" name="save" id="save" class="btn"
                                                            value="SUBMIT" /><?php
    $forward = $this->session->get('__user_id')? "user/applications/action/view": "";
    echo !empty($id)? "<input type='hidden' id='userid' name='userid' value='".$id."' /><input type='hidden' id='forward' name='forward' value='".$forward."' />": "";
    ?></td>
                                                </tr>
                                                <?php }?>
                                            </table>
                                        </form>
            </section>
        </main>
    </div>
    
        <?php echo view("addons/".($this->session->get('__user_id')? "secure_footer": "public_footer"), array('page'=>'new_account'));?>
</body>

</html>