<?php $msg = empty($msg)? get_session_msg($this): $msg;
$areas['cancel_retirement_application'] = "Cancel Retirement Application";
$areas['request_confirmation'] = "Request Confirmation";
$areas['cancel_transfer_application'] = "Cancel Transfer Application";
$areas['cancel_leave_application'] = "Cancel Leave Application";
$this->session = \Config\Services::session();
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo (!empty($area) && !empty($areas[$area]))? $areas[$area]: 'My Job Profile';?></title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/trumbowyg.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('job-my_profile', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js',  'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js', 'trumbowyg.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-JM8P0P17Z6');
var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo (!empty($area) && !empty($areas[$area]))? $areas[$area]: 'My Job Profile';?></h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <table border="0" cellspacing="0" cellpadding="10" <?php echo !$this->session->get('school')? " style='width:100%;' ":'';?>>
                    <?php
                    if (!empty($area) && $area == 'request_confirmation') {
                        if ($this->session->get('startdate') && strtotime($this->session->get('startdate')) < strtotime('- 6 months')) {
                            if ($this->session->get('hasapplied') == 'Y') {
                                echo "<tr><td colspan='2'>".format_notice($this, 'WARNING: You have already applied for confirmation. Please await a response from the approving authorities.')."</td></tr>";
                            } else {
                                echo "<tr><td colspan='2'><div id='confirm_btn_div' class='textfield' style='width:100%;'><button type='button' name='confirm' id='confirm' onclick=\"updateFieldLayer('".base_url()."/Job/request_confirmation/submit/Y/id/".$this->session->get('postingid')."','','confirm_btn_div','confirm_results','')\" class='btn'>Request Job Confirmation</button>
                                <br><span class='smalltext'>Clicking this button notifies the ministry about your request. This notifies the relevant authorities to review your teaching profile and history (already available on this system and offline). 
                                <br>We will contact you when any action is taken on your request.</span>
                                </div>
                                <div id='confirm_results'></div></td></tr>";
                            }
                        } else {
                            echo "<tr><td colspan='2'>".format_notice($this, 'WARNING: Sorry. You have not yet exceeded 6 months on the job to apply for confirmation.')."</td></tr>";
                        }
                    } elseif (!empty($area) && $area == 'cancel_retirement_application') {
                        if (!empty($application)) {
                            echo "<tr><td colspan='2'><div id='cancel_retirement_btn_div' class='textfield' style='width:100%;'><button type='button' name='confirm' id='confirm' onclick=\"updateFieldLayer('".base_url()."/Retirement/cancel/submit/Y','','cancel_retirement_btn_div','confirm_retirement_results','')\" class='btn'>Cancel Retirement Application</button>
                                <br><span class='smalltext'>Clicking this button notifies the ministry about your request. This also deletes your retirement application on record. 
                                </div>
                                <div id='confirm_retirement_results'></div></td></tr>";
                        } else {
                            echo "<tr><td colspan='2'>".format_notice($this, 'WARNING: You do not have an application that can be cancelled. <br>If you applied for retirement, the application can not be cancelled any more unless rejected.')."</td></tr>";
                        }
                    } elseif (!empty($area) && $area == 'cancel_transfer_application') {
                        if (!empty($application)) {
                            echo "<tr><td colspan='2'><div id='cancel_transfer_btn_div' class='textfield' style='width:100%;'><button type='button' name='confirm' id='confirm' onclick=\"updateFieldLayer('".base_url()."/Transfer/cancel/submit/Y','','cancel_transfer_btn_div','confirm_transfer_results','')\" class='btn'>Cancel Transfer Application</button>
                                <br><span class='smalltext'>Clicking this button notifies the ministry about your request. This also deletes your transfer application on record. 
                                </div>
                                <div id='confirm_transfer_results'></div></td></tr>";
                        } else {
                            echo "<tr><td colspan='2'>".format_notice($this, 'WARNING: You do not have an application that can be cancelled. <br>If you applied for a transfer, the application can not be cancelled any more unless rejected.')."</td></tr>";
                        }
                    } elseif (!empty($area) && $area == 'cancel_leave_application') {
                        if (!empty($application)) {
                            echo "<tr><td colspan='2'><div id='cancel_leave_btn_div' class='textfield' style='width:100%;'><button type='button' name='confirm' id='confirm' onclick=\"updateFieldLayer('".base_url()."/Leave/cancel/submit/Y','','cancel_leave_btn_div','confirm_leave_results','')\" class='btn'>Cancel Leave Application</button>
                                <br><span class='smalltext'>Clicking this button notifies the ministry about your request. This also deletes your leave application on record. 
                                </div>
                                <div id='confirm_leave_results'></div></td></tr>";
                        } else {
                            echo "<tr><td colspan='2' width='100%'>".format_notice($this, 'WARNING: You do not have an application that can be cancelled. <br>If you applied for a leave, the application can not be cancelled any more unless rejected.')."</td></tr>";
                        }
                    }


                    if ($this->session->get('school')) {?>

                    <tr>
                        <td class="label">School:</td>
                        <td class='value' style="padding-right:42px;">
                            <?php echo $this->session->get('school');?></td>
                    </tr>
                    <tr>
                        <td class="label">Job Name:</td>
                        <td class='value' style="padding-right:42px;">
                            <?php echo $this->session->get('jobname');?></td>
                    </tr>
                    <tr>
                        <td class="label top">Job Description:</td>
                        <td class='value'>
                            <?php echo html_entity_decode($this->session->get('jobdescription'), ENT_QUOTES);?>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">Start Date:</td>
                        <td class='value'>
                            <?php echo date('d-M-Y', strtotime($this->session->get('startdate')));?>
                        </td>
                    </tr>
                    <?php
                    } else {
                        echo "<tr class='d-block w-100 pt-3'><td class='d-block w-100' colspan='2'".(!empty($area)? " style=''" : "")." >".format_notice($this, "WARNING: You do not have a current job posting. <br><br>You can <a href=\"javascript:updateFieldLayer('".base_url()."/Job/submit_current_job','','','currentjobdiv','')\">report your current job</a> for approval or <a href='".base_url()."/Job/lists/action/apply'>search vacancies and apply</a> for a job.")."</td></tr>
                        
                        <tr><td><div id='currentjobdiv'></div></td></tr>";
                    }
                    ?>
                </table>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>