<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Verify Document</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('page-verify_document', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    </script>
</head>

<body style="margin:0px;">
    <?php echo view("addons/public_header", array("page"=>"verify"));?>

    <div class="container-fluid mx-auto p-3 pt-5 p-md-5 m-0 app-area-page">
        <div class="verify-area d-flex justify-content-center">
            <div class="verify-area-wrap bg-white p-3 p-md-5 mt-5 border">
                <span class="d-inline-block h2 mb-4">Verify Document</span>
                <div class="form-area">
                    <table id="verifydocument__form" class='simpleform'>
                        <?php echo !empty($msg)?"<tr><td>".format_notice($this,$msg)."</td></tr>": "";?>
                        <tr>
                            <td>
                                <div class="nextdiv label">Document Type:</div>
                                <div class="nextdiv">
                                    <input type="text" id="documenttype__documenttypes" name="documenttype__documenttypes" placeholder="Select Document Type" class="textfield selectfield" value="" />
                                    <input type='hidden' id='documenttype' name='documenttype' value='' />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div class="nextdiv label">Certificate Number: </div>
                                <div class="nextdiv">
                                    <input type="text" id="trackingnumber" name="trackingnumber" placeholder="Enter Number" class="textfield numbersonly" value="" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <button type="button" class="greybtn submitbtn" id="checktracking" name="checktracking">VALIDATE CERTIFICATE NUMBER</button>
                                <input type='hidden' id='verifydocument__type' name='verifydocument__type' value='verify_document' />
                                <input type='hidden' id='verifydocument__ignorepostprocessing' name='verifydocument__ignorepostprocessing' value='verify_document' />
                            </td>
                        </tr>
                        <tr>
                            <td class="mesgwrap">
                                <div id='verifydocument__resultsdiv'></div>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php echo view("addons/public_footer");?>

</body>

</html>