<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?> School</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->

    <?php echo minify_js('school-new_school', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.callout.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()"
    onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php
# Do not show the header, menu and footer when editing
if (empty($id)) {?>
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <?php echo view("addons/secure_header");?>
        <tr class="app-area">
            <td valign="top" colspan="2">
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr class="app-area-wrap">
                        <td id="menucontainer"><?php echo view("addons/menu");?></td>
                        <td class="bodyspace">
                            <?php }?>

                            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                                <tr class="app-area-title">
                                    <td class="h1 grey">
                                        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?>
                                        School</td>
                                </tr>
                                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
                                <tr class="app-area-content">
                                    <td>
                                        <form id="school_data" method="post" autocomplete="off"
                                            action="<?php echo base_url().'/School/add'.(!empty($id)? '/id/'.$id: '');?>"
                                            class='simplevalidator'>
                                            <table border="0" cellspacing="0" cellpadding="10">
                                                <tr>
                                                    <td class="label">Name:</td>
                                                    <td style="padding-right:42px;">
                                                        <?php
                                                        if (!empty($id) && $this->session->get('schoolname') || (!empty($action) && $action=='view')) {
                                                            echo "<div class='value'>".$this->session->get('schoolname')."</div>";
                                                        } else {
                                                        ?>
                                                        <input type="text" id="schoolname" name="schoolname"
                                                            title="School Name" class="textfield"
                                                            value="<?php echo $this->session->get('schoolname');?>" />
                                                        <?php } ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">School Type:</td>
                                                    <td><?php if (!empty($id) && $this->session->get('schooltype__schooltypes') || (!empty($action) && $action=='view')) {
    echo "<div class='value'>".$this->session->get('schooltype__schooltypes')."</div>";
} else {?><input type="text" id="schooltype__schooltypes" name="schooltype__schooltypes" title="School Type"
                                                            placeholder="Select School Type"
                                                            class="textfield selectfield"
                                                            value="<?php echo $this->session->get('schooltype__schooltypes');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Date Registered:</td>
                                                    <td><?php if (!empty($id) && $this->session->get('dateschoolregistered') || (!empty($action) && $action=='view')) {
    echo "<div class='value'>".date('d-M-Y', strtotime($this->session->get('dateschoolregistered')))."</div>";
} else {?><input type="text" id="dateschoolregistered" name="dateschoolregistered" title="Date Registered"
                                                            class="textfield datefield history"
                                                            value="<?php echo $this->session->get('dateschoolregistered')? date('d-M-Y', strtotime($this->session->get('dateschoolregistered'))):'';?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Email Address:</td>
                                                    <td><input type="text" id="schoolemailaddress"
                                                            name="schoolemailaddress" title="School Email Address"
                                                            placeholder="Optional" class="textfield email optional"
                                                            value="<?php echo $this->session->get('schoolemailaddress');?>" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Telephone:</td>
                                                    <td><?php if (!empty($action) && $action=='view') {
    echo "<div class='value'>".$this->session->get('schooltelephone')."</div>";
} else {?><input type="text" id="schooltelephone" name="schooltelephone" title="School Telephone"
                                                            placeholder="(e.g: 0782123456)" maxlength="10"
                                                            class="textfield numbersonly telephone"
                                                            value="<?php echo $this->session->get('schooltelephone');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label top">Address:</td>
                                                    <td><?php if (!empty($id) && $this->session->get('schooladdress__addressline') || (!empty($action) && $action=='view')) {
    echo "<div class='value'>".
        $this->session->get('schooladdress__addressline')." ".$this->session->get('schooladdress__county')." <br>".$this->session->get('schooladdress__district').", ".$this->session->get('schooladdress__country')."</div>";
} else {?><input type="text" id="schooladdress" name="schooladdress" title="School Address"
                                                            class="textfield placefield physical"
                                                            value="<?php echo $this->session->get('schooladdress__addressline');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <?php if (!(!empty($action) && $action=='view')) {?>
                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td><input type="submit" name="save" id="save" class="btn"
                                                            value="SAVE" /><?php
    echo !empty($id)? "<input type='hidden' id='schoolid' name='schoolid' value='".$id."' />": "";
    echo "<input type='hidden' id='forward' name='forward' value='school/lists".(!empty($action) && $action!='view'? '/action/'.$action: '')."' />";
    ?></td>
                                                </tr>
                                                <?php }?>
                                            </table>
                                        </form>

                                    </td>
                                </tr>
                            </table>

                            <?php
# Do not show the header and footer when editing
if (empty($id)) {?>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <?php echo view("addons/secure_footer");?>
    </table>
    <?php } else {
    echo "<input type='hidden' id='layerid' name='layerid' value='' />";
}?>
</body>

</html>