<?php

namespace App\Controllers;

/**
 * This class controls viewing census submissions on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/30/2015
 */
use App\Models\_census;
class Census extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->census = new _census();
    }
    
    
    
    
    # Add a new census
    public function add()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'submit_teacher_census_data');
        # Remove any session variables if still in the session.
        if (empty($_POST)) {
            $this->census->clear_session();
        }

        
        # If user has posted the form for processing
        if (!empty($_POST)) {
            $data['result'] = $this->request->getPost('censusid')? $this->census->update_census($this->request->getPost('censusid'), $this->request->getPost()): $this->census->add_new($this->request->getPost());
                
            if ($this->request->getPost('censusid')) {
                $data['censusid'] = $this->request->getPost('censusid');
            }
            $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "The census details have been submitted for approval.": $data['result']['msg'];
            $this->census->clear_session();
            # Redirect to appropriate page if successful
            $this->session->set('msg', $data['msg']);
            
            if ($data['result']['boolean'] && !$this->request->getPost('censusid')) {
                if (check_access($this, 'view_teacher_census_report', 'boolean', false) || check_access($this, 'verify_teacher_census_submissions', 'boolean', false)) {
                    $action = check_access($this, 'verify_teacher_census_submissions', 'boolean', false)? 'verify': 'view';
                    return redirect()->to('census/lists/action/'.$action);
                } else {
                    redirect()->to(base_url().get_user_dashboard($this, $this->session->get('__user_id')));
                }
            } elseif ($this->request->getPost('censusid') && $this->request->getPost('forward')) {
                $data['forward'] = base_url().$this->request->getPost('forward');
            }
        }
        
        #If editing, load the id details into the session for the first time
        if (!empty($data['id']) && empty($_POST)) {
            $this->census->populate_session($data['id']);
        }
        $data['responsibility_list'] = $this->census->get_list(array('action'=>'responsibility'));
        $data['training_list'] = $this->census->get_list(array('action'=>'training'));
        echo view('census/new_census', $data);
    }
    
    
    
    
    
    # View a census list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        if (empty($data['action'])) {
            $data['action'] = 'view';
        }
        $instructions['action'] = array('view'=>'view_teacher_census_report', 'verify'=>'verify_teacher_census_submissions');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->census->get_list($data);
        echo view('census/list_census', $data);
    }
    
    
    
    
    
    # View a census sub-list
    public function sub_lists()
    {
        $data = filter_forwarded_data($this);
        
        if (!empty($data['id']) && !empty($data['type'])) {
            $data['list'] = $this->census->get_list(array('action'=>$data['type'].'_sub_list', 'census_id'=>$data['id']));
        } else {
            $data['msg'] = "ERROR: The list instructions can not be resolved.";
        }
        
        $data['area'] = 'census_sub_lists';
        echo view('addons/basic_addons', $data);
    }
    
    
    
    #Verify the census before proceeding to the next stage
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a census
            $result = $this->census->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('approve'=>'approved', 'reject'=>'rejected', 'archive'=>'archived', 'restore'=>'restored');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            $this->session->set('msg', ($result['boolean']? "The census has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The census could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_census';
            echo view('addons/basic_addons', $data);
        }
    }
}

/* End of controller file */
