<?php

namespace App\Controllers;

/**
 * This class controls viewing leave pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_leave;
use App\Models\_job;

class Leave extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->leave = new _leave();
        $this->job = new _job();
    }
    
    
    # View leave lists
    public function lists()
    {
        $data = filter_forwarded_data($this);
        $instructions['action'] = array('view'=>'view_leave_applications', 'approve'=>'verify_leave_at_county_level', 'verify'=>'verify_leave_at_ministry_level', 'send'=>'prepare_leave_verification_letter');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->leave->get_list($data);
        #Make sure the approver has a signature on file if they are going to issue a letter
        if (!empty($data['list']) && !$this->session->get('__signature') && !empty($data['action']) && $data['action']=='send') {
            $data['msg'] = "WARNING: You need to <a href='".base_url()."/Profile/user_data'>upload a signature</a> to send a leave confirmation letter.";
            $this->session->set('__nosignature', 'Y');
        }
        echo view('leave/list_leaves', $data);
    }
    
    
    
    # Cancel a leave application
    public function cancel()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'cancel_leave_application');
        
        if (!empty($data['submit'])) {
            $result = $this->leave->cancel();
            $data['msg'] = $result? 'The leave has been cancelled.': 'ERROR: The leave could not be cancelled.';
            $data['area'] = 'basic_msg';
            echo view('addons/basic_addons', $data);
        } else {
            $data['application'] = $this->leave->get_application();
        
            $data['area'] = 'cancel_leave_application';
            $data['job'] = $this->job->populate_session();
            echo view('job/my_profile', $data);
        }
    }
    
    
    # Verify leave application
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a leave
            $result = $this->leave->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('reject'=>'rejected', 'approve'=>'approved');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            
            $this->session->set('msg', ($result['boolean']? "The leave has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The leave could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_leave';
            echo view('leave/addons', $data);
        }
    }
    
    
    
    # Apply for leave
    public function apply()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'apply_for_leave');
        
        #User is submitting application
        if (!empty($_POST)) {
            $result = $this->leave->submit_application($this->request->getPost());
            $data['msg'] = $result['boolean']? 'Your leave application has been submitted.': $result['msg'];
            if ($result['boolean']) {
                $this->session->remove(['leavestartdate','leaveenddate','leavereason']);
                $this->session->set('msg', $data['msg']);
                return redirect()->to('leave/cancel');
            }
        }
        
        $data['currentJob'] = $this->leave->get_current_school();
        echo view('leave/apply', $data);
    }
}

/* End of controller file */
