<?php

namespace App\Controllers;

/**
 * This class handles running cron jobs for the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_cron;

class Cron extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->cron = new _cron();
    }
    
    
    # Update the query cache
    public function update_query_cache()
    {
        # DISABLE IF IN DEV TO SEE IMMEDIATE CHANGES IN YOUR QUERIES
        if (ENABLE_QUERY_CACHE) {
            $this->query_reader->load_queries_into_cache();
        }
    }
    
    
    # Update the message cache
    public function update_message_cache()
    {
        # DISABLE IF IN DEV TO SEE IMMEDIATE CHANGES IN YOUR MESSAGES
        if (ENABLE_MESSAGE_CACHE) {
            $this->messenger->load_messages_into_cache();
        }
    }
    
    
    
    # Fetch and run all system jobs
    public function fetch_and_run_sys_jobs()
    {
        $data = filter_forwarded_data($this);
        $result = $this->cron->run_available_jobs();
        
        #Log the results from the run
        if (!empty($data['jobid'])) {
            $this->cron->update_status($data['jobid'], array(
            'job_type'=>'jobs',
            'job_code'=>'fetch_and_run_sys_jobs',
            'result'=>($result['bool']? 'success': 'fail'),
            'job_details'=>$result
        ));
        }
    }
}

/* End of controller file */
