<?php

namespace App\Controllers;

/**
 * This class controls generic searching on the website.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/26/2015
 */
use App\Models\_finder;

class Search extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->finder = new _finder();
    }
        
    
    # Load a search list
    public function load_list()
    {
        $data = filter_forwarded_data($this);
        
        if (!empty($data['type'])) {
            $data = $this->finder->load_list($data);
            echo view($data['type'].'/list', $data);
        } else {
            $data['msg'] = "ERROR: Basic search functionality for this list is not yet added.";
            $data['area'] = "basic_msg";
            echo view('addons/basic_addons', $data);
        }
    }
}

/* End of controller file */
