<?php

namespace App\Controllers;

/**
 * This class controls viewing transfer pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_transfer;
use App\Models\_job;

class Transfer extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->transfer = new _transfer();
        $this->job = new _job();
    }
    
    
    # View transfer lists
    public function lists()
    {
        $data = filter_forwarded_data($this);
        $instructions['action'] = array('view'=>'view_transfer_applications', 'institutionapprove'=>'verify_transfer_at_institution_level', 'countyapprove'=>'verify_transfer_at_county_level', 'ministryapprove'=>'verify_transfer_at_ministry_level', 'pca'=>'submit_transfer_pca');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->transfer->get_list($data);
        #Make sure the approver has a signature on file if they are going to issue a letter
        if (!empty($data['list']) && !$this->session->get('__signature') && !empty($data['action']) && in_array($data['action'], array('pca', 'countyapprove'))) {
            $data['msg'] = "WARNING: You need to <a href='".base_url()."/Profile/user_data'>upload a signature</a> to generate a transfer confirmation document.";
            $this->session->set('__nosignature', 'Y');
        }
        echo view('transfer/list_transfers', $data);
    }
    
    
    
    # Cancel a transfer application
    public function cancel()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'cancel_transfer_application');
        
        if (!empty($data['submit'])) {
            $result = $this->transfer->cancel();
            $data['msg'] = $result? 'The transfer has been cancelled.': 'ERROR: The transfer could not be cancelled.';
            $data['area'] = 'basic_msg';
            echo view('addons/basic_addons', $data);
        } else {
            $data['application'] = $this->transfer->get_application();
        
            $data['area'] = 'cancel_transfer_application';
            $data['job'] = $this->job->populate_session();
            echo view('job/my_profile', $data);
        }
    }
    
    
    # Verify transfer application
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a transfer
            $result = $this->transfer->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('reject'=>'rejected', 'approve'=>'approved');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            
            $this->session->set('msg', ($result['boolean']? "The transfer has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The transfer could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_transfer';
            echo view('transfer/addons', $data);
        }
    }
    
    
    
    
    # Apply for transfer
    public function apply()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'apply_for_transfer');
        
        #User is submitting application
        if (!empty($_POST)) {
            $result = $this->transfer->submit_application($this->request->getPost());
            $data['msg'] = $result['boolean']? 'Your transfer application has been submitted.': $result['msg'];
            if ($result['boolean']) {
                $this->session->remove(['school__schools', 'schoolid', 'transferdate','transferreason']);
                $this->session->set('msg', $data['msg']);
                return redirect()->to('transfer/cancel');
            }
        }
        
        $data['currentJob'] = $this->transfer->get_current_school();
        echo view('transfer/apply', $data);
    }
}

/* End of controller file */
