<?php
/**
 * This file contains functions that are used in loading data for drop downs
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/08/2015
 */




# Get a list of options
# Allowed return values: [div, option]
function get_option_list($obj, $list_type, $return = 'div', $searchBy="", $more=array())
{
    $optionString = '';
    $session = session();
    $query_reader = new \App\Models\_query_reader();
    
    switch ($list_type) {
        case "district":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (name LIKE '".$searchString."%' OR name LIKE '% ".$searchString."%') ": " 1=1 ";

            $districts = $query_reader->get_list('get_list_of_districts', array('search_query'=>$searchQuery));
            foreach ($districts as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "institutions":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (MATCH(name) AGAINST('+".implode(" +", explode(" ", $searchString))."') OR name LIKE '".$searchString."%' OR name LIKE '% ".$searchString."%') ": " 1=1 ";
            $institutions = $query_reader->get_list('get_list_of_institutions', array('search_query'=>$searchQuery));
            foreach ($institutions as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "country":
            $countries = $query_reader->get_list('get_list_of_countries');
            foreach ($countries as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "county":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (C.name LIKE '".$searchString."%' OR C.name LIKE '% ".$searchString."%') ": " 1=1 ";
            $orderBy = " C.name ASC";
            
            # Get the district field if given
            $district = array_key_contains('-district-', $more);
            
            $counties = $query_reader->get_list('get_county_list_data', array('search_query'=>$searchQuery, 'order_by'=>$orderBy, 'limit_text'=>'100'));
            foreach ($counties as $row) {
                $optionString .= "<div data-value='".$row['value']."'";
                $optionString .= $district['boolean']? " onclick=\"universalUpdate('".$more[$district['key']]."', '".$row['district_name']."')\"": "";
                $optionString .= " >".$row['display']."</div>";
            }
        break;
        
        
        case "citizentype":
            $types = array('By Birth', 'By Naturalization', 'By Registration');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        case "institutiontype":
            $types = array('University', 'College', 'Technical', 'Secondary', 'Primary');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        case "month":
            $months = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
            foreach ($months as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        case "pastyear":
            for ($i=date('Y'); $i>(date('Y') - 80); $i--) {
                $optionString .= "<div data-value='".$i."'>".$i."</div>";
            }
        break;
        
        
        case "subjecttype":
            $types = array('Major', 'Other', 'Minor');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;

        case "covid":
            $types = array('Yes', 'No');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;

        case "subjectname":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            // if(!isset($_SESSION['__permission_group']) || isset($_SESSION['__permission_group']) != '2') $more['teaching_category'] = (isset($more['teaching_category']) == 'undefined' && isset($_SESSION['teacherQualCat']))? $_SESSION['teacherQualCat']:"";
            if(!isset($more['teaching_category']) && isset($_SESSION['teacherQualCat'])) $more['teaching_category'] = $_SESSION['teacherQualCat'];
            if (!empty($more['teaching_category']) && empty($searchString)) $searchQuery = ' stage = "'.$more['teaching_category'].'" ';
            elseif(!empty($searchString) && empty($more['teaching_category']))  $searchQuery = " (name LIKE '".$searchString."%' OR name LIKE '% ".$searchString."%') ";
            elseif(!empty($searchString) && !empty($more['teaching_category']))  $searchQuery = " (name LIKE '".$searchString."%' OR name LIKE '% ".$searchString."%') AND stage = '".$more['teaching_category']."' ";
            else $searchQuery = " 1=1 ";
            
            $subjectnames = $query_reader->get_list('get_list_of_ministry_subjects', array('search_query'=>$searchQuery));
            foreach ($subjectnames as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;

        case "title":
            if (!empty($more['teaching_category'])) $searchString = ' stage = "'.$more['teaching_category'].'" ';
            elseif(!isset($more['teaching_category']) && isset($_SESSION['teacherQualCat'])) $searchString = ' stage = "'.$_SESSION['teacherQualCat'].'" ';
            $searchString = (!empty($searchString) ? $searchString :' 1 = 1 ');
            
            $titles = $query_reader->get_list('get_list_of_ministry_titles', array('search_query'=>$searchString));
            foreach ($titles as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "jobroles":
            $roles = $query_reader->get_list('get_duties');
            foreach ($roles as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "roles":
            $roles = $query_reader->get_list('get_permission_groups', array('system_only'=>"'N','Y'"));
            foreach ($roles as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "schooljobs":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (V.topic LIKE '".$searchString."%' OR V.topic LIKE '% ".$searchString."%') ": " 1=1 ";
            
            $jobs = $query_reader->get_list('get_school_jobs', array('user_id'=>$session->get('__user_id'), 'search_query'=>$searchQuery));
            foreach ($jobs as $row) {
                $optionString .= "<div data-value='".$row['value']."'onclick=\"universalUpdate('vacancyid', '".$row['id']."')\">".$row['display']."</div>";
            }
            
        break;
        
        
        case "users":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (P.first_name LIKE '".$searchString."%' OR P.first_name LIKE '% ".$searchString."%' OR P.nin LIKE '% ".$searchString."%' OR P.last_name LIKE '".$searchString."%') AND U.status='active' ": " U.status='active' ";
            $orderBy = " ORDER BY P.last_name ASC";
            
            $users = $query_reader->get_list('get_user_list_data', array('search_query'=>" U.id <> '".$session->get('__user_id')."' AND ".$searchQuery, 'order_by'=>$orderBy, 'limit_text'=>'100'));
            
            foreach ($users as $row) {
                $optionString .= "<div data-value='".$row['value']."' onclick=\"universalUpdate('userid', '".$row['id']."')\">".$row['display']."</div>";
            }
        break;
        
        
        case "schooltypes":
            $types = array('Primary', 'Secondary', 'Tertiary', 'University', 'Other');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        case "teachers":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (P.first_name LIKE '".$searchString."%' OR P.first_name LIKE '% ".$searchString."%' OR P.nin LIKE '% ".$searchString."%' OR P.ipps LIKE '% ".$searchString."%' OR P.last_name LIKE '".$searchString."%') AND U.status='active' ": " U.status='active' ";
            $orderBy = " ORDER BY P.last_name ASC";
            
            if ($session->get('__permission_group') && $session->get('__permission_group') == '3') {
                if ($session->get('__posting')) {
                    $users = $query_reader->get_list('get_user_list_data', array('search_query'=>$searchQuery." AND PS.institution_id='".$session->get('__posting')."'  AND U.permission_group_id='2' ", 'order_by'=>$orderBy, 'limit_text'=>'100'));
                } else {
                    $users = array();
                }
            } else {
                $users = $query_reader->get_list('get_user_list_data', array('search_query'=>$searchQuery." AND U.permission_group_id='2' ", 'order_by'=>$orderBy, 'limit_text'=>'100'));
            }
            
            foreach ($users as $row) {
                $optionString .= "<div data-value='".$row['value']."' onclick=\"universalUpdate('teacherid', '".$row['id']."')\">".$row['display']."</div>";
            }
        break;
        
        
        
        case "contactreason":
            $reasons = array('Account Access', 'Job Application', 'Information Security', 'General Inquiries');
            foreach ($reasons as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
    
        case "grades":
            $searchstring = ' ';
            if (!empty($more['category'])) {
                $searchString = ' WHERE g.grade_category = "'.$more['category'].'" ';
                //SEARCHSTRING
            }
            $searchString = (!empty($searchString) ? $searchString :' WHERE 1 = 1 ');
            $grades = $query_reader->get_list('get_teacher_grades', array('searchstring'=>$searchString));
            foreach ($grades as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
            
        case "categories":
        #exit("reached");
            $grades = $query_reader->get_list('grade_category');
            foreach ($grades as $row) {
                $optionString .= "<div data-value='".$row['value']."' class='grade_category'  >".$row['display']."</div>";
            }
        break;
        
        
        
        case "interviewresults":
            //$results = array('Failed','Inconclusive','Passed','Awarded');
            $results = array('Appointed','Unsuccessful');
            foreach ($results as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        case "shortlists":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " vacancy_id='".$more['jobid']."' AND shortlist_name LIKE '".$searchString."%' ": " vacancy_id='".$more['jobid']."' ";
            $orderBy = " ORDER BY shortlist_name ASC";
            
            $shortlists = $query_reader->get_list('get_shortlist_data', array('search_query'=>$searchQuery, 'order_by'=>$orderBy, 'limit_text'=>'100'));
            foreach ($shortlists as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;
        
        
        case "schools":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (INS.name LIKE '".$searchString."%' OR INS.name LIKE '% ".$searchString."%') ": " 1=1 ";
            $orderBy = " ORDER BY I.name ASC";
            
            $schools = $query_reader->get_list('get_institution_data', array('search_query'=>$searchQuery, 'order_by'=>$orderBy, 'limit_text'=>'100'));
            foreach ($schools as $row) {
                $optionString .= "<div data-value='".$row['value']."' onclick=\"universalUpdate('schoolid', '".$row['id']."')\">".$row['display']."</div>";
            }
        break;
        
        
        
        case "leavetypes":
            $reasons = array('Study Leave', 'Normal Leave', 'Marternity Leave', 'Other Leave');
            foreach ($reasons as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
      
      #Grounds for Leave
       case 'grounds':
        $grounds = array('Medical Leave','Study Leave', 'Marternity Leave', 'Normal Leave', 'Other Leave');
         
        foreach ($grounds as $row) {
            $optionString .= "<div data-value='".$row."'>".$row."</div>";
        }
            
        break;
        
        
        
        
        case "documenttypes":
            $reasons[0] = array('type'=>'confirmation_letter', 'display'=>'Job Confirmation Letter');
            $reasons[1] = array('type'=>'transfer_letter', 'display'=>'Job Transfer Letter');
            $reasons[2] = array('type'=>'transfer_pca', 'display'=>'Job Transfer PCA');
            $reasons[3] = array('type'=>'verification_letter', 'display'=>'Leave Confirmation Letter');
            $reasons[4] = array('type'=>'retirement_letter', 'display'=>'Retirement Confirmation Letter');
            $reasons[5] = array('type'=>'registration_certificate', 'display'=>'Teacher Registration Certificate');
            
            foreach ($reasons as $row) {
                $optionString .= "<div data-value='".$row['display']."' onclick=\"universalUpdate('documenttype', '".$row['type']."')\">".$row['display']."</div>";
            }
        break;
        
        
        
        case "boards":
        case "viewonlyboards":
            $boards = $query_reader->get_list('get_list_of_boards');
            foreach ($boards as $row) {
                $optionString .= "<div data-value='".$row['value']."' onclick=\"universalUpdate('boardid', '".$row['id']."')";
                if ($list_type == "boards") {
                    $optionString .= ";updateFieldLayer('".base_url()."/Interview/view_board_members/boardid/".$row['id']."','','','memberlist_div','');";
                }
                
                $optionString .= "\">".$row['display']."</div>";
            }
        break;
        
        
        
        case "reporttypes":
            $types[0] = array('type'=>'registerednumbers', 'display'=>'Number of Registered Teachers');
            $types[1] = array('type'=>'teacherappointments', 'display'=>'Teacher Appointments');
            $types[2] = array('type'=>'teacherstatus', 'display'=>'Teacher Status');
                        $types[3] = array('type'=>'monitoring', 'display'=>'Monitoring');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row['display']."' onclick=\"updateFieldLayer('".base_url()."/Teacher/report_specification/type/".$row['type']."','','','reportspecs','')\">".$row['display']."</div>";
            }
        break;
        
        
        
        case "registerednumbers":
            $types[0] = array('type'=>'gender', 'display'=>'By Gender');
            $types[1] = array('type'=>'grades', 'display'=>'By Grade');
            $types[2] = array('type'=>'subjects', 'display'=>'By Subject');
            $types[3] = array('type'=>'schools', 'display'=>'By School');
            $types[4] = array('type'=>'districts', 'display'=>'By District');
            $types[5] = array('type'=>'region', 'display'=>'By Region');
            $types[6] = array('type'=>'religion', 'display'=>'By Religion');
            $types[7] = array('type'=>'category', 'display'=>'By Teaching Category');
            $types[8] = array('type'=>'retirement', 'display'=>'Due for Retirement');
            $types[9] = array('type'=>'position', 'display'=>'By Position');
            
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row['display']."'>".$row['display']."</div>";
            }
        break;
        
        
        
        case "teacherappointments":
            $types[0] = array('type'=>'post', 'display'=>'By Post');
            $types[1] = array('type'=>'school', 'display'=>'By School');
            $types[2] = array('type'=>'district', 'display'=>'By District');
            $types[3] = array('type'=>'region', 'display'=>'By Region');
            
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row['display']."'>".$row['display']."</div>";
            }
        break;
        
        case "monitoring":
        $types[0]=array('type'=>'applications', 'display'=>'Applications');
        $types[1]=array('type'=>'department', 'display'=>'Department');
        $types[2]=array('type'=>'staff', 'display'=>'Staff');

        foreach ($types as $row) {
            $optionString .= "<div data-value='".$row['display']."'>".$row['display']."</div>";
        }
        break;
        
        case "teacherstatus":
            $types[0] = array('type'=>'applied', 'display'=>'Applied');
            $types[1] = array('type'=>'probation', 'display'=>'On Probation');
            $types[2] = array('type'=>'confirmed', 'display'=>'Confirmed');
            $types[3] = array('type'=>'onleave', 'display'=>'On Leave');
            $types[4] = array('type'=>'retired', 'display'=>'Retired');
            $types[5] = array('type'=>'pending', 'display'=>'Pending');
            $types[6] = array('type'=>'verified', 'display'=>'Verified');
            $types[7] = array('type'=>'approved', 'display'=>'Approved');
            $types[8] = array('type'=>'certified', 'display'=>'Certified');
            $types[9] = array('type'=>'rejected', 'display'=>'Rejected');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row['display']."'>".$row['display']."</div>";
            }
        break;

        case "emp_district":
            $searchString = !empty($searchBy)? htmlentities(restore_bad_chars($searchBy), ENT_QUOTES): "";
            $searchQuery = !empty($searchString)? " (name LIKE '".$searchString."%' OR name LIKE '% ".$searchString."%') ": " 1=1 ";

            $districts = $query_reader->get_list('get_list_of_districts', array('search_query'=>$searchQuery));
            foreach ($districts as $row) {
                $optionString .= "<div data-value='".$row['value']."'>".$row['display']."</div>";
            }
        break;

        case "teacherQualCat":
            $types = array('Pre-Primary', 'Primary', 'Secondary', 'Tertiary');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;

        case "religion":
            $types = array('Anglican', 'Roman Catholic', 'Islam', 'Pentecostal','Orthodox','Seventh-Day Adventist','Bahai Faith');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;

        case "employmentCat":
            $types = array('Government', 'Private');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;

        case "region":
            $types = array('Northern', 'Western', 'Eastern', 'Central');
            foreach ($types as $row) {
                $optionString .= "<div data-value='".$row."'>".$row."</div>";
            }
        break;
        
        
        
        
        
    }
    
    return !empty($optionString)? $optionString: (($return == 'div')? "<div data-value=''>No options available</div>": "<option value=''>No options available</option>");
}
