<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Models\_query_reader;

class _report extends Model
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->query_reader = new _query_reader();
    }
    
    # Get list of reports
    public function get_list($instructions=array())
    {
        $searchString = " 1=1 ";
        if (!empty($instructions['action']) && $instructions['action']== 'user') {
            $searchString = " L.log_code LIKE 'user_%' ";
        } elseif (!empty($instructions['action']) && $instructions['action']== 'system') {
            $searchString = " L.log_code LIKE 'system_%' ";
        }
        
        
        # If a search phrase is sent in the instructions
        if (!empty($instructions['searchstring'])) {
            $searchString .= " AND ".$instructions['searchstring'];
        }
        
        # Instructions
        $count = !empty($instructions['pagecount'])? $instructions['pagecount']: NUM_OF_ROWS_PER_PAGE;
        $start = !empty($instructions['page'])? ($instructions['page']-1)*$count: 0;
        
        return $this->query_reader->get_list('get_log_list_data', array('search_query'=>$searchString, 'limit_text'=>$start.','.($count+1), 'order_by'=>" L.id DESC "));
    }
}
