<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Apply for Leave</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('leave-apply', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-JM8P0P17Z6');
var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php if ($this->session->get('__user_id')) {
                            echo view("addons/menu");
                        }?>
            </nav>
        </aside>
        <main class="app-area-content p-3 pt-5 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Apply for Leave</h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="leave_application" method="post" autocomplete="off" action="<?php echo base_url().'/Leave/apply';?>" class='simplevalidator'>
                                            <table border="0" cellspacing="0" cellpadding="10"
                                                <?php echo empty($currentJob)? " width='100%' ": "";?>>
                                                <?php
                                                if (!empty($currentJob)) {
                                                ?>
                                                <tr>
                                                    <td class="label">Desired Start Date:</td>
                                                    <td><input type="text" id="leavestartdate" name="leavestartdate"
                                                            title="Leave Start Date" class="textfield datefield"
                                                            style="width:95%;"
                                                            value="<?php echo $this->session->get('leavestartdate'); ?>" />
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label">Desired End Date:</td>
                                                    <td><input type="text" id="leaveenddate" name="leaveenddate"
                                                            title="Leave End Date" class="textfield datefield"
                                                            style="width:95%;"
                                                            value="<?php echo $this->session->get('leaveenddate'); ?>" />
                                                    </td>
                                                </tr>
                                                <tr>

                                                    <!-- Grounds for Leave -->
                                                <tr>
                                                    <td class="label">Grounds for Leave:</td>
                                                    <td>
                                                        <input type="text" id="leave__grounds" name="leave__grounds"
                                                            title="Select Grounds For Leave"
                                                            placeholder="Select or Search Grounds for Leave"
                                                            class="textfield selectfield searchable" value=""
                                                            style="width:85%;">

                                                    </td>
                                                </tr>

                                                <td class="label top">Reason:</td>
                                                <td><textarea id="leavereason" name="leavereason"
                                                        title="Reason for Leave" class="textfield"
                                                        style="width:300px; height:150px;"><?php echo $this->session->get('leavereason'); ?></textarea>
                                                </td>
                                </tr>

                                <tr>
                                    <td>&nbsp;</td>
                                    <td><input type="submit" name="save" id="save" class="btn" value="SUBMIT" /></td>
                                </tr>
                                <?php
                                } else {
                                        echo "<tr><td>".format_notice($this, "WARNING: You do not have a current job posting to submit a leave application.")."</td></tr>";
                                    }
                                ?>
                            </table>
                            </form>
            </section>
        </main>
    </div>
    
    <?php echo view("addons/secure_footer");?>
</body>

</html>