<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: User List</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.shadowbox.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.pagination.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->

    <?php echo minify_js('user-list_users', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js', 'tmis.list.js','bootstrap.min.js', 'tmis.shadowbox.js', 'tmis.pagination.js', 'tmis.search.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()"
    onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Users</h3>
                <?php if(check_access($this, 'add_new_user', 'boolean')) echo "<div class='nextdiv addcontenticon' data-url='user/add' title='Click to add'></div>";?><?php if(check_access($this, 'view_users', 'boolean') && !empty($list)) echo "
                        <div class='microform'>
                        <div class='nextdiv'><input type='text' id='startdate' name='startdate' title='Start Date' placeholder='Start Date' class='textfield datefield clickactivated' value='".date('d-M-Y', strtotime('- 1 month'))."' /></div>
                        <div class='nextdiv' style='min-width:20px; font-size:20px;'>TO</div>
                        <div class='nextdiv'><input type='text' id='enddate' name='enddate' title='End Date' placeholder='End Date' class='textfield datefield clickactivated' value='".date('d-M-Y', strtotime('now'))."' /></div>                            
                        <button type='button' class='nextdiv btn submitmicrobtn' name='download' id='download' title='Download' value='Download' style='width:110px;'>Download</button>";?>
                <input type='hidden' id='action' name='action' value='<?php echo base_url()."/User/download";?>' />
    </div>

    <!-- <div class='nextdiv downloadcontenticon' style='margin-left:5px;' data-url='user/download' title='Click to download'></div>";?></div> -->

    <div class="listsearchfield"><input type="text" id="usersearch__users" data-type="user" name="usersearch__users"
            placeholder="Search Users" class="findfield" value="" />
        <input type='hidden' id='usersearch__displaydiv' name='usersearch__displaydiv' value='usersearch__1' />
        <input type='hidden' id='usersearch__action' name='usersearch__action'
            value='<?php echo base_url()."/Search/load_list/action/".(!empty($action)? $action: 'view');?>' />
    </div>
    </section>
    <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
        <div id="listcontainer">
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                    <td>
                        <div id="paginationdiv__usersearch_list">
                            <div id="usersearch__1"><?php echo view('user/list', array(
                                        'listid'=>'usersearch',
                                        'list'=>(!empty($list)? $list: array()), 
                                        'action'=>(!empty($action)? $action: ''), 
                                        'msg'=>(!empty($msg)? $msg: '') 
                                        ));?>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php if(!empty($list)){?>
                <tr>
                    <td style="padding:40px 15px 10px 15px; ">
                        <div class='centerpagination' style="margin:0px;padding:0px;">
                            <div id="usersearch" class="paginationdiv">
                                <div class="previousbtn" style='display:none;'>&#x25c4;</div>
                                <div class="selected">1</div>
                                <div class="nextbtn">&#x25ba;</div>
                            </div><input name="paginationdiv__usersearch_action" id="paginationdiv__usersearch_action"
                                type="hidden"
                                value="<?php echo base_url()."/Search/load_list/type/user/action/".(!empty($action)? $action: 'view');?>" />
                            <input name="paginationdiv__usersearch_maxpages" id="paginationdiv__usersearch_maxpages"
                                type="hidden" value="<?php echo NUM_OF_LISTS_PER_VIEW;?>" />
                            <input name="paginationdiv__usersearch_noperlist" id="paginationdiv__usersearch_noperlist"
                                type="hidden" value="<?php echo NUM_OF_ROWS_PER_PAGE;?>" />
                            <input name="paginationdiv__usersearch_showdiv" id="paginationdiv__usersearch_showdiv"
                                type="hidden" value="paginationdiv__usersearch_list" />
                        </div>
                    </td>
                </tr>
                <?php }?>
            </table>
        </div>
    </section>
    </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>