<?php
# Which page is this header being loaded on?
$page = !empty($page)? $page: "home";

#Show the home link if you are not on the home page
$homeLink = $page != "home"? "<a href=\"".base_url()."\">Home</a> ": "";
#Show the other links as active if on that page
$aboutLink = $page != "about_us"? "<a href=\"".base_url()."/Page/about_us\">About TMIS</a>": "<span class='label'>About TMIS</span>";
$faqsLink = " ".($page != "faqs"? "<a href=\"".base_url()."/Page/faqs\">FAQs</a>": "<span class='label'>FAQs</span>");
$verifyLink = " ".($page != "verify"? "<a href=\"".base_url()."/Page/verify\">Verify</a>": "<span class='label'>Verify</span>");
$logoutLink = ($page != "login" && isset($_SESSION['__user_id'])? " <a href=\"".base_url()."/Account/logout\">Logout</a>": "");

#Show the other links as active if on that page
$termsLink = $page != "terms"? "<a href=\"".base_url()."/Page/terms_of_use\">Terms</a>": "<span class='label'>Terms</span>";
$privacyLink = " ".($page != "privacy"? "<a href=\"".base_url()."/Page/privacy_policy\">Privacy</a>": "<span class='label'>Privacy</span>");
$contactLink = " ".($page != "contact_us"? "<a href=\"".base_url()."/Page/contact_us\">Contact Us</a>": "<span class='label'>Contact Us</span>");
#$applyLink = " &nbsp;&nbsp;|&nbsp;&nbsp; ".($page != "new_account"? "<a href=\"".base_url()."register/step_one\">New Account</a>": "<span class='label'>New Account</span>");

?>

<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url(); ?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url(); ?>/favicon.ico" type="image/x-icon">
    <?php $this->session = \Config\Services::session(); ?>
    <title><?php echo SITE_TITLE; ?>: Welcome</title>
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.shadowbox.css" />
    <link rel="stylesheet" href="<?php echo base_url(); ?>/assets/css/tmis.pagination.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
	<link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <script src="https://unpkg.com/swiper@7.0.8/swiper-bundle.min.js" crossorigin="anonymous"></script>
    <?php echo minify_js('home', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.callout.js', 'tmis.fileform.js', 'tmis.responsive.js', 'tmis.list.js', 'tmis.shadowbox.js', 'tmis.pagination.js', 'tmis.search.js'));?>
</head>

<body>
    <div class="container-fluid mx-auto p-0 m-0 app-area-login home">
        <div class="app-area-login-img bg-black">
            <div class="swiper mySwiper">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                    <img src="<?php echo base_url();?>/assets/images/h3.jpg" />
                    </div>
                    <div class="swiper-slide">
                    <img src="<?php echo base_url();?>/assets/images/h4.jpg" />
                    </div>
                    <div class="swiper-slide">
                    <img src="<?php echo base_url();?>/assets/images/h1.jpg" />
                    </div>
                    <div class="swiper-slide">
                    <img src="<?php echo base_url();?>/assets/images/h2.jpg" />
                    </div>
                </div>
            </div>
        </div>
        <div class="app-area-login-form p-3 p-md-5 pt-5">
            <span class="d-block logo-wrap">
                <img src="<?php echo base_url();?>/assets/images/tmis-logo.svg" alt="TMIS logo">
            </span>
            <span class="h3 d-block pt-3">Sign In</span>
            <span class="d-block">
                <div id="registration_close_btn">&nbsp;</div>
            </span>
            <p>Teacher Management Information System</p>
            <table width="100%" class="bg-white">
                <tr>
                    <td>
                        <div class="loginhomeform">
                            <form method="post" autocomplete="off" class="my-md-3 p-4 py-3">
                                <table>
                                    <tr>
                                        <td class="trlogin">
                                            <label for="inputEmail4" class="labeltxt ">Username</label>
                                            <input type="text" id="loginusername" name="loginusername" placeholder="Username" class="textfield form-control-input p-3" value="" maxlength="100" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="trlogin">
                                            <label for="inputPassword4" class="labeltxt" style="padding-top: 8px;">Password</label>
                                            <input type="password" id="loginpassword" name="loginpassword" placeholder="Password" class="textfield form-control-input p-3" value="" maxlength="100" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <a class="p-login text-black" href="<?php echo base_url() . '/Account/forgot'; ?>">Forgot Username or Password?</a>
                                            <button type="button" class="bluebtn" id="submitlogin" name="submitlogin">LOGIN</button>
                                            <p class="mt-5">
                                                Don't have an account?
                                                <a href="<?php echo base_url() . '/Register/step_one'; ?>" class="fw-normal text-primary">Register as a Teacher</a>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            </form>
                        </div>
                    </td>
                </tr>
            </table>
            <ul class="d-md-flex mt-3 p-3 bg-white">
                <li class="nav-item">
                    <?php echo $aboutLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $verifyLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $faqsLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $termsLink; ?>
                </li>
                <li class="nav-item ms-3">
                    <?php echo $contactLink; ?>
                </li>
            </ul>
        </div>
    </div>
    <script>
        var swiper = new Swiper(".mySwiper", {
            spaceBetween: 30,
            effect: "fade",
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
        });
    </script>
</body>

</html>