<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Contact Us</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('page-contact_us', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"contact_us"));?>

    <div class="container-fluid mx-auto p-3 pt-5 p-md-5 m-0 app-area-page">
        <div class="contact-area bg-white p-3 p-md-5 mt-5 border">
            <span class="d-block h2 mb-4">Contact Us</span>
            <div class="contact-form">
                <form method="post" autocomplete="off" action="<?php echo base_url();?>/Page/contact_us" class="simplevalidator d-block">
                    <table class="d-block">
                        <?php

                        $this->session = \Config\Services::session();
                        if (!empty($result) && $result) {
                            echo "<tr><td style='padding-bottom:100px;'>".format_notice($this, $msg)."</td></tr>";
                        } else {
                            echo !empty($msg)? "<tr><td colspan='2'>".format_notice($this, $msg)."</td></tr>": "";
                        
                        ?>

                        <tr>
                            <td class="label">Your Name</td>
                            <td>
                                <input type="text" id="yourname" name="yourname" class="textfield" value="<?php echo $this->session->get('yourname'); ?>" maxlength="100" />
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Email Address: </td>
                            <td>
                                <input type="text" id="emailaddress" name="emailaddress" class="textfield email" value="<?php echo $this->session->get('emailaddress'); ?>" maxlength="100" />
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Telephone: </td>
                            <td>
                                <input type="text" id="telephone" name="telephone" placeholder="Optional (e.g: 0782123456)" class="textfield numbersonly telephone optional" value="<?php echo $this->session->get('telephone'); ?>" maxlength="10" />
                            </td>
                        </tr>
                        <tr>
                            <td class="label">Reason: </td>
                            <td>
                                <input type="text" id="reason__contactreason"
                                    name="reason__contactreason" placeholder="Enter or Select reason" class="textfield selectfield editable" value="<?php echo $this->session->get('reason__contactreason'); ?>" />
                            </td>
                        </tr>
                        <tr class="message-area">
                            <td class="label" valign="top">Message: </td>
                            <td>
                                <textarea id="details" name="details" placeholder="Enter your message here" class="textfield">
                                    <?php echo $this->session->get('details'); ?>
                                </textarea>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2"><input type="submit" class="btn" id="submitmessage" name="submitmessage" value="SEND" /></td>
                        </tr>
                        <?php } ?>
                    </table>
                </form>
            </div>
            <div class="contact-info">
                <div class="address-info">
                    <span>
                        <h5>Address</h5>
                        <h3>Ministry of Education and Sports</h3>
                        <p>P.O BOX 7063 Kampala, Uganda</p>
                    </span>
                    <span>
                        <span>Assistant Commissioner ICT</span>
                        <!-- <br>Email: <a href='mailto:Muinda@yahoo.com'>Muinda@yahoo.com</a> -->
                        <span>Tel: +256(0)-41-4259338</span>
                    </span>
                </div>
                <div class="team-info">
                    <h3>TMIS Team</h3>
                    <span>
                        <h5>Email 1:</h5>
                        <a
                            href='mailto:valentine.owor@education.go.ug'>valentine.owor@education.go.ug</a>
                    </span>
                    <span>
                        <h5>Email 2:</h5>
                        <a href='mailto:regan.matsiko@education.go.ug'>regan.matsiko@education.go.ug</a>
                    </span>
                    <span>
                        <h5>Email 3:</h5>
                        <a href='mailto:joan.namono@education.go.ug'>joan.namono@education.go.ug</a>
                    </span>
                    <span>
                        Tel: +256(0)-41-4671680 | +256(0)-41-4671681
                    </span>
                </div>
            </div>
        </div>
    </div>

    <?php echo view("addons/public_footer", array("page"=>"contact_us"));?>


</body>

</html>