<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: FAQs</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous">
    </script>
    <?php echo minify_js('page-faqs', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"faqs"));?>

    <div class="container-fluid mx-auto p-3 pt-5 p-md-5 m-0 app-area-page">
        <div class="faqs-area bg-white p-3 p-md-5 mt-5 border">
            <span class="d-block h2 mb-4">Frequently Asked Questions (FAQs)</span>
            <div class="accordion" id="accordionExample">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                            What is TMIS?
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            The Teacher Management Information System (TMIS) is a simple user-friendly solution to
                            supporting a harmonized and timely access to teacher information at all administrative
                            levels of the Ministry of Education and Sports and associated agencies; at national,
                            district and education institution levels. Its main objective is to solve the problem of
                            dis-jointed teacher records accross the various sections of government and the education
                            ministry. By enabling teachers to take control of their records and increasing transparency
                            in the ministry's provision of services, it is speeding up service delivery, improving the
                            ministry's efficiency and the relationship of the teaching professionals with government.
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                            Why do I need to register with TMIS?
                        </button>
                    </h2>
                    <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            If you are a teacher, your record will need to be in the system to be matched across the
                            various organizations in the ministry. Registering on TMIS provides you with the benefit of
                            a faster service for your requests such as issuance of certificates, requesting transfers,
                            leave application and many more. It is a service that will be indispensible for a teacher's
                            interaction with the ministry and you are therefore encouraged to register earlier so that
                            your application is approved sooner.
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                            Who owns TMIS?
                        </button>
                    </h2>
                    <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            TMIS is owned by the Ugandan Ministry of Education and Sports (MoES). It has full control
                            over your access and service provision as detailed in the <a
                                href='<?php echo base_url();?>/Page/terms_of_use'>terms of use</a>. TMIS was developed
                            with the support of The United Nations Educational, Scientific and Cultural Organization
                            (UNESCO); a specialized agency of the United Nations.
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                            How do I get TMIS access?
                        </button>
                    </h2>
                    <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            To get access to the services of TMIS, you have to be a teacher in a government sponsored
                            school or a professional in the education ministry of Uganda. Teachers register on the
                            system through a 4-stage form that begins at the home page. Other non-teacher education
                            professionals are encouraged to apply for approval using the <a
                                href='<?php echo base_url();?>/Register/step_one'>signup link</a> on our website.
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                            I am stuck. Where can I find help?
                        </button>
                    </h2>
                    <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive"
                        data-bs-parent="#accordionExample">
                        <div class="accordion-body">
                            If you are stuck and can not complete a process on the website, you are encouraged to send
                            our admin team a message using our <a
                                href='<?php echo base_url();?>/Page/contact_us'>contact us form</a> any time of day.
                            Inquiries will be handled depending on urgency and first-come-first-served basis. Our admin
                            team determines the urgency of the matter or inquiry. You are advised to send only relevant
                            messages and be patient for a response. Additional inquiries on the same matter do not speed
                            up our response to you.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo view("addons/public_footer");?>

</body>

</html>