<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: <?php echo !empty($id)? 'Edit': 'New';?> Group</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('permission-new_group', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>
    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Edit'): 'New';?>Group</h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="group_data" method="post" autocomplete="off"
                                            action="<?php echo base_url().'/Permission/add_group'.(!empty($id)? '/id/'.$id: '');?>"
                                            class='simplevalidator'>
                                            <table border="0" cellspacing="0" cellpadding="10">

                                                <tr>
                                                    <td class="label">Group Name:</td>
                                                    <td style="padding-right:42px;"><?php if (!empty($action)) {
    echo "<div class='value'>".$this->session->get('groupname')."</div>";
} else {?><input type="text" id="groupname" name="groupname" title="Group Name" class="textfield" style="width:97%;"
                                                            value="<?php echo $this->session->get('groupname');?>" /><?php }?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="label top">Permissions:</td>
                                                    <td><?php
        echo "<div style='max-height:200px; overflow-y: auto; overflow-x: hidden;'>
        <table border='0' cellspacing='0' cellpadding='0' class='listtable'>";
        
        if (!empty($permission_list)) {
            echo "<tr class='header'><td>Category</td><td>Permission</td><td nowrap>Is Default</td></tr>";
            foreach ($permission_list as $permission) {
                echo "<tr class='listrow'><td>".ucfirst(str_replace('_', ' ', $permission['category']))."</td>
                    
                <td><input type='checkbox' name='permission[]' id='permission_".$permission['id']."' value='".$permission['id']."' ".($this->session->get('permission') && in_array($permission['id'], $this->session->get('permission'))? ' checked': '')."><label for='permission_".$permission['id']."' style='white-space: nowrap;'>".$permission['permission']."</label></td>
                    
                <td><input type='radio' onclick=\"selectAll(this,'*permission_".$permission['id']."')\" name='default' id='default_".$permission['id']."' value='".$permission['id']."' ".($this->session->get('default') && $this->session->get('default') == $permission['id']? ' checked': '')."><label for='default_".$permission['id']."'>Default</label></td></tr>";
            }
        } else {
            echo "<tr><td>".format_notice($this, 'ERROR: There are no permissions to show.')."</td></tr>";
        }
        echo "</table></div>";
        ?></td>
                                                </tr>
                                                <tr>
                                                    <td class="label">For System Use Only:</td>
                                                    <td><?php if (!empty($action)) {
            echo "<div class='value'>".strtoupper($this->session->get('forsystem'))."</div>";
        } else {?>
                                                        <div class="nextdiv"><input type="radio" name="forsystem"
                                                                id="forsystem_no" value="no"
                                                                <?php echo(!$this->session->get('forsystem') || ($this->session->get('forsystem') && $this->session->get('forsystem')=='no')? 'checked': '');?>>
                                                            <label for="forsystem_no">NO</label>
                                                        </div>
                                                        <div class="nextdiv"><input type="radio" name="forsystem"
                                                                id="forsystem_yes" value="yes"
                                                                <?php echo($this->session->get('forsystem') && $this->session->get('forsystem')=='yes'? 'checked': '');?>>
                                                            <label for="forsystem_yes">YES</label>
                                                        </div>

                                                        <?php }?>
                                                    </td>
                                                </tr>
                                                <?php if (!(!empty($action) && $action=='view')) {?>
                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td><input type="submit" name="save" id="save" class="btn"
                                                            value="SAVE" />
                                                        <input type='hidden' id='errormessage' name='errormessage'
                                                            value='Enter all required fields to continue including selecting a default permission.' /><?php
    echo !empty($id)? "<input type='hidden' id='groupid' name='groupid' value='".$id."' />": "";
    echo "<input type='hidden' id='forward' name='forward' value='/permission/update_group' />";
    ?>
                                                    </td>
                                                </tr>
                                                <?php }?>
                                            </table>
                                        </form>
            </section>
        </main>
    </div>
    
    <?php echo view("addons/secure_footer");?>

</body>

</html>