<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <title>
        <?php echo SITE_TITLE;?>: Register</title>
    <?php  $this->session = \Config\Services::session(); ?>
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <?php echo minify_js('register-step_three', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.callout.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"register"));?>

    <div class="app-area-page pt-5">
        <div class="container">
            <div class="row">
                <div class="col-12 bg-white p-md-5 my-5 border">
                    <form id="home_registration_form" method="post" autocomplete="off" action="<?php echo base_url();?>/Register/step_three">
                        <div class="vregform step-3 p-0 m-0">
                            <table class="bg-white d-block">
                                <tbody class="row g-4">
                                    <tr class="col-12">
                                        <td class="h3 d-block border-bottom pb-3 black m-0">Registration (Step 3 of 4)</td>
                                    </tr>
                                    <?php echo !empty($msg)?"<tr class='col=12'><td>".format_notice($this, $msg)."</td></tr>": ""; $msg = "";  ?>
                                    <tr class="col-12">
                                        <td class="" style="">Education</td>
                                    </tr>
                                    <tr class="col-12">
                                        <td>
                                            <div id="form_div__education">
                                                <?php echo view('addons/basic_addons', array('area'=>'education_form'));?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr class="col-12">
                                        <td>
                                            <div id="institution_list">
                                                <?php  if ($this->session->get('education_list')) {
                                                    echo view('addons/basic_addons', array('area'=>'education_list'));
                                                } else {   ?>
                                                    <table border="0" cellspacing="0" cellpadding="0" class="resultslisttable">
                                                        <tr>
                                                            <td>Current List</td>
                                                        </tr>
                                                        <tr>
                                                            <td>No education added yet.</td>
                                                        </tr>
                                                    </table>
                                                <?php  } ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php if(isset($_SESSION['teacherQualCat']) && $_SESSION['teacherQualCat'] != 'Primary') { ?> 
                                    <tr>
                                        <td class="greybg h3" style="padding-left:5px;">What are your teaching Subjects?</td>
                                    </tr>
                                    <?php } ?>
                                    <tr>
                                        <td>
                                            <div id="form_div__subject">
                                                <?php echo view('addons/basic_addons', array('area'=>'subject_form'));?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div id="subject_list">
                                                <?php   if ($this->session->get('subject_list')) {
                                                    echo view('addons/basic_addons', array('area'=>'subject_list'));
                                                } else {  ?>
                                                    <table border="0" cellspacing="0" cellpadding="0" class="resultslisttable">
                                                        <tr>
                                                            <td>Current List</td>
                                                        </tr>
                                                        <tr>
                                                            <td>No subject added yet.</td>
                                                        </tr>
                                                    </table>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="greybg h3 p-2">Qualification Documents:</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div id="form_div__document">
                                                <?php echo view('addons/basic_addons', array('area'=>'document_form'));?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <div id="document_list">
                                                <?php if ($this->session->get('document_list')) {
                                                    echo view('addons/basic_addons', array('area'=>'document_list'));
                                                } else {   ?>
                                                    <table border="0" cellspacing="0" cellpadding="0" class="resultslisttable">
                                                        <tr>
                                                            <td>Current List</td>
                                                        </tr>
                                                        <tr>
                                                            <td>No document added yet.</td>
                                                        </tr>
                                                    </table>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table width="100%" border="0" cellspacing="0" cellpadding="0" class='buttonnav m-0 p-0'>
                                                <tbody class="">
                                                    <tr class="row">
                                                        <td class="col-auto w-auto">
                                                            <button type="button" name="backtostep2" id="backtostep2" class="greybtn back">BACK</button>
                                                        </td>
                                                        <td class="col-auto w-auto">
                                                            <?php if ($this->session->get('just_preview_3')) {
                                                                echo "<button type='button' name='step3preview' id='step3preview' class='greybtn'>SAVE &amp; PREVIEW</button>";
                                                            } else {  ?>
                                                                <button type="button" name="step3save" id="step3save" class="greybtn">SAVE &amp; EXIT</button>
                                                                <?php } ?>
                                                        </td>
                                                        <td class="col-auto w-auto">
                                                            <input type="submit" name="step3" id="step3" value="NEXT" class="btn next w-100" />
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="4" class='note text-start m-0 px-0 py-3'>Applications not completed within 14 days will be automatically deleted by the system.</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php echo view("addons/public_footer");?>

</body>

</html>