<?php

namespace App\Controllers;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require '../vendor/autoload.php';
require '../vendor/phpmailer/phpmailer/src/Exception.php';
require '../vendor/phpmailer/phpmailer/src/PHPMailer.php';
require '../vendor/phpmailer/phpmailer/src/SMTP.php';

class Home extends BaseController
{
    public function index()
    {
        $this->session->set('view_data','Hi there I am from the session');

        $page['view_data'] =$this->session->get('view_data'); // Normal way
        $page['session'] =$this->session;                     // Pass in the object
        return view('welcome_message', $page);
    }

    public function email()
    {
        //Create an instance; passing `true` enables exceptions
        $mail = new PHPMailer(true);

        try {
            //Server settings
            $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
            $mail->isSMTP();                                            //Send using SMTP
            $mail->Host       = SMTP_HOST;                              //Set the SMTP server to send through
            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
            $mail->Username   = SMTP_USER;                              //SMTP username
            $mail->Password   = SMTP_PASS;                               //SMTP password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;            //Enable implicit TLS encryption
            $mail->Port       = 465;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
            $mail->SMTPOptions = array(
                'ssl' => array(
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
                ));
            
            //Recipients
            $mail->setFrom(NOREPLY_EMAIL, SITE_TITLE);
            $mail->addAddress('rkateregga@nwt.ug', 'Senior Major');     //Add a recipient
            // $mail->addAddress('ellen@example.com');               //Name is optional
            $mail->addReplyTo(NOREPLY_EMAIL, SITE_TITLE);
            $mail->addCC('dbuwembo@nwt.ug', 'Emeritus of CSS');
            // $mail->addCC('admin@pss.gov');
            // $mail->addCC('deng1504@yahoo.com');
            // $mail->addCC('test@pss.gov');
            // $mail->addBCC('bcc@example.com');
        
            //Attachments
            // $mail->addAttachment('/var/tmp/file.tar.gz');         //Add attachments
            // $mail->addAttachment('/tmp/image.jpg', 'new.jpg');    //Optional name
        
            //Content
            $mail->isHTML(true);                                  //Set email format to HTML
            $mail->Subject = 'PhpMailer ekola';
            $mail->Body    = '<p style="text-align: justify;color: #4169E1;font-size: 1.5em;">It is Working!</p>
            <h1>Php Mailer is working!</h1>
            <p style="text-align: justify;"><strong>Psalm 91</strong></p>
            <p style="text-align: justify; padding-left: 40px;"><sup><strong>1</strong></sup> He that dwelleth in the secret place of the most High shall abide under the shadow of the Almighty.</p>
            <p style="text-align: justify; padding-left: 40px;"><sup><strong>2</strong></sup> I will say of the Lord, He is my refuge and my fortress: my God; in him will I trust.</p>
            <p style="text-align: justify; padding-left: 40px;"><sup><strong>3</strong></sup> Surely he shall deliver thee from the snare of the fowler, and from the noisome pestilence.</p>
            <p style="text-align: justify; padding-left: 40px;"><sup><strong>4</strong></sup> He shall cover thee with his feathers, and under his wings shalt thou trust: his truth shall be thy shield and buckler.</p>
            <p style="text-align: justify; padding-left: 40px;"><sup><strong>5</strong></sup> Thou shalt not be afraid for the terror by night; nor for the arrow that flieth by day;</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>6</strong></sup> Nor for the pestilence that walketh in darkness; nor for the destruction that wasteth at noonday. </p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>7</strong></sup> A thousand shall fall at thy side, and ten thousand at thy right hand; but it shall not come nigh thee. </p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>8</strong></sup> Only with thine eyes shalt thou behold and see the reward of the wicked.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>9</strong></sup> Because thou hast made the Lord, which is my refuge, even the most High, thy habitation;</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>10</strong></sup> There shall no evil befall thee, neither shall any plague come nigh thy dwelling.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>11</strong></sup> For he shall give his angels charge over thee, to keep thee in all thy ways.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>12</strong></sup> They shall bear thee up in their hands, lest thou dash thy foot against a stone.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>13</strong></sup> Thou shalt tread upon the lion and adder: the young lion and the dragon shalt thou trample under feet.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>14</strong></sup> Because he hath set his love upon me, therefore will I deliver him: I will set him on high, because he hath known my name.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>15</strong></sup> He shall call upon me, and I will answer him: I will be with him in trouble; I will deliver him, and honour him.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>16</strong></sup> With long life will I satisfy him, and shew him my salvation.</p>
            <p style="text-align: justify;">&nbsp;</p>
            <p style="text-align: justify;"><strong>Psalm 23</strong></p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>1</strong></sup> The Lord is my shepherd; I shall not want.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>2</strong></sup> He maketh me to lie down in green pastures: he leadeth me beside the still waters.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>3</strong></sup> He restoreth my soul: he leadeth me in the paths of righteousness for His name\'s sake.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>4</strong></sup> Yea, though I walk through the valley of the shadow of death, I will fear no evil: for thou art with me; thy rod and thy staff they comfort me.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>5</strong></sup> Thou preparest a table before me in the presence of mine enemies: thou anointest my head with oil; my cup runneth over.</p>
			<p style="text-align: justify; padding-left: 40px;"><sup><strong>6</strong></sup> Surely goodness and mercy shall follow me all the days of my life: and I will dwell in the house of the Lord for ever.</p>			
            <p style="text-align: justify;">&nbsp;</p>';
            $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
        
            $mail->send();
            echo 'Message has been sent';
        } catch (Exception $e) {            
            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
            echo '<pre>' .var_export($e, true). '</pre>';
        }
    }

    public function sendMail()
    {
        $email = \Config\Services::email(); // loading for use

        // Email to
        $email->setTo("rkateregga@nwt.ug");
        $email->setFrom(NOREPLY_EMAIL, SITE_TITLE);
        $email->setSubject("Sample Mail - Online Web Tutor");
        $email->setMessage("This is test mail with CI4.");

        // Attachment
        // $email->attach(FCPATH . "data/1.png");

        // Send email
        if ($email->send()) {
            echo 'Email successfully sent, please check.';
        } else {
            $data = $email->printDebugger(['headers']);
            print_r($data);
        }
    }

    public function pdf(){
        $dompdf = new \Dompdf\Dompdf();
        $dompdf->loadHtml(view('pdf'));
        // setting paper to portrait, also we have landscape
        $dompdf->setPaper('A4', 'portrait');
        $options = $dompdf->getOptions();
        $options->setIsRemoteEnabled(true);
        $options->setIsHtml5ParserEnabled(true);
        $dompdf->setOptions($options);
        $contxt = stream_context_create([ 
            'ssl' => [ 
                'verify_peer' => FALSE, 
                'verify_peer_name' => FALSE,
                'allow_self_signed'=> TRUE
            ] 
        ]);
        $dompdf->setHttpContext($contxt);
        $dompdf->render();
        // Download pdf
        $dompdf->stream('registration_certificate'); 
        // to give pdf file name
        // $dompdf->stream("myfile");

    }
    
}
