<?php

namespace App\Controllers;

/**
 * This class controls viewing messages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */

class Message extends BaseController
{
    # Send new system message
    public function send_new_system()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'send_system_message');
        if (empty($data['reply'])) {
            $this->messenger->clear_session();
        }
        
        #Sending a system message
        if (!empty($_POST)) {
            $data['result'] = $this->messenger->send_from_form('system', $this->request->getPost());
            # Remove the session variables whether the message was sent or not
            $this->messenger->clear_session();
            $data['area'] = "message_sending_results";
            echo view('addons/basic_addons', $data);
        } else {
            $data['action'] = "send_new_system";
            echo view('message/new_message', $data);
        }
    }
    
    
    
    # Send new email message
    public function send_new_email()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'send_email_message');
        if (empty($data['reply'])) {
            $this->messenger->clear_session();
        }
        
        #Sending a system message
        if (!empty($_POST)) {
            $data['result'] = $this->messenger->send_from_form('email', $this->request->getPost());
            # Remove the session variables whether the message was sent or not
            $this->messenger->clear_session();
            $data['area'] = "message_sending_results";
            echo view('addons/basic_addons', $data);
        } else {
            $data['action'] = "send_new_email";
            echo view('message/new_message', $data);
        }
    }
    
    
    # Send new sms message
    public function send_new_sms()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'send_sms_message');
        if (empty($data['reply'])) {
            $this->messenger->clear_session();
        }
        
        #Sending an sms message
        if (!empty($_POST)) {
            $data['result'] = $this->messenger->send_from_form('sms', $this->request->getPost());
            # Remove the session variables whether the message was sent or not
            $this->messenger->clear_session();
            $data['area'] = "message_sending_results";
            echo view('addons/basic_addons', $data);
        } else {
            $data['action'] = "send_new_sms";
            echo view('message/new_message', $data);
        }
    }
    
    
    
    # View message inbox
    public function inbox()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_message_inbox');
        
        $data['action'] = 'inbox';
        $data['list'] = $this->messenger->get_list(array('action'=>'inbox'));
        echo view('message/list_messages', $data);
    }
    
    
    # View message archive
    public function archive()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_archived_messages');
        
        $data['action'] = 'archive';
        $data['list'] = $this->messenger->get_list(array('action'=>'archive'));
        echo view('message/list_messages', $data);
    }
    
    
    # View sent messages
    public function sent()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_sent_messages');
        
        $data['action'] = 'sent';
        $data['list'] = $this->messenger->get_list(array('action'=>'sent'));
        echo view('message/list_messages', $data);
    }
    
        
    
    # Verify the message - just keeping the function name consistent
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Verify a message
            $result = $this->messenger->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('archive'=>'archived', 'restore'=>'restored');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            $this->session->set('msg', ($result['boolean']? "The message has been ".$actionWord: "ERROR: The message could not be ".$actionWord));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_user';
            echo view('addons/basic_addons', $data);
        }
    }
    
    
    
    # Reply to a message
    public function reply()
    {
        $data = filter_forwarded_data($this);
        
        # 1. Prefill the message details with previous message
        if (!empty($data['id'])) {
            $this->messenger->populate_session($data['id']);
        } else {
            $this->session->set('msg', 'ERROR: We can not resolve the previous message.');
        }
        
        # 2. Redirect to appropriate send format page to respond
        if (empty($data['format'])) {
            $this->session->set('msg', 'ERROR: We can not resolve the send format.');
        }
        return redirect()->to(!empty($data['format'])? base_url().'/Message/send_new_'.$data['format'].'/reply/message': base_url().'/Message/inbox');
    }
    
    
    
    # View details of a message
    public function details()
    {
        $data = filter_forwarded_data($this);
        
        if (!empty($data['id'])) {
            $data['message'] = $this->messenger->message_details($data['id']);
            $this->messenger->change_status($data['id'], 'read');
        } else {
            $data['msg'] = 'ERROR: We can not resolve the message.';
        }
        
        $data['area'] = 'message_details';
        echo view('addons/basic_addons', $data);
    }
}

/* End of controller file */
