<?php

namespace App\Controllers;

/**
 * This class controls viewing promotion pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 02/08/2015
 */
use App\Models\_promotion;
use App\Models\_job;

class Promotion extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->promotion = new _promotion();
        $this->job = new _job();
    }
    
    
    # View promotion application list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        if (empty($data['action'])) {
            $data['action'] = 'view';
        }
        $instructions['action'] = array('view'=>'view_promotion_applications', 'report'=>'view_promotions');
        check_access($this, get_access_code($data, $instructions));
        
        
        echo view('page/under_construction', $data);
    }
    
    
    
    # Cancel a promotion application
    public function cancel()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'cancel_promotion_application');
        
        $data['area'] = 'cancel_promotion_application';
        $data['job'] = $this->job->populate_session();
        echo view('job/my_profile', $data);
    }
    
    
    
    
    # Apply for promotion
    public function apply()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'apply_to_retire');
        
        if (!empty($_POST)) {
            $result = $this->promotion->submit_application($this->request->getPost());
            $data['msg'] = $result['boolean']? 'Your promotion has been submitted.': $result['msg'];
            if ($result['boolean']) {
                $this->session->set('msg', $data['msg']);
                return redirect()->to('promotion/cancel');
            }
        }
        
        $data['current_application'] = $this->promotion->details($this->session->get('__user_id'));
        echo view('promotion/apply', $data);
    }
}

/* End of controller file */
