<?php

namespace App\Controllers;

/**
 * This class controls viewing schools on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_school;

class School extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->school = new _school();
    }
    
    
    # View current school where this teacher works
    public function view_current()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_current_school');
        
        $data['school'] = $this->school->get_current();
        echo view('school/current', $data);
    }
    
    
    
    # View previous schools where the teacher has worked before
    public function view_previous()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'view_previous_schools');
        
        $data['list'] = $this->school->get_previous();
        echo view('school/previous', $data);
    }
    
    
    
    # Add a new school
    public function add()
    {
        $data = filter_forwarded_data($this);
        if (!(!empty($data['action']) && $data['action'] == 'view' && !empty($data['id']))) {
            check_access($this, 'add_new_school');
        }
        # Remove any session variables if still in the session.
        if (empty($_POST)) {
            $this->school->clear_session();
        }

        
        # If user has posted the form for processing
        if (!empty($_POST)) {
            $data['result'] = $this->request->getPost('schoolid')? $this->school->update_school($this->request->getPost('schoolid'), $this->request->getPost()): $this->school->add_new($this->request->getPost());
                
            if ($this->request->getPost('schoolid')) {
                $data['schoolid'] = $this->request->getPost('schoolid');
            }
            $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "The school details have been saved.": $data['result']['msg'];
            $this->school->clear_session();
            # Redirect to appropriate page if successful
            $this->session->set('msg', $data['msg']);
            # Go to verification page if user has permission
            if (check_access($this, 'verify_school_data_updates', 'boolean')) {
                $data['action'] = 'verify';
            }
            
            if ($data['result']['boolean'] && !$this->request->getPost('schoolid')) {
                return redirect()->to('school/lists'.(!empty($data['action']) && $data['action'] !='view'? '/action/'.$data['action']: ''));
            } elseif ($this->request->getPost('schoolid')) {
                $data['forward'] = base_url().$this->request->getPost('forward');
            }
        }
        
        #If editing, load the id details into the session for the first time
        if (!empty($data['id']) && empty($_POST)) {
            $this->school->populate_session($data['id']);
        }
        echo view('school/new_school', $data);
    }
    
    
    
    
    
    # View a school list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        if (empty($data['action'])) {
            $data['action'] = 'view';
        }
        $instructions['action'] = array('view'=>'view_school_data_changes', 'report'=>'view_schools', 'verify'=>'verify_school_data_updates');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->school->get_list($data);
        echo view('school/list_schools', $data);
    }
    
    
    
    # Download the list
    public function download()
    {
        check_access($this, 'view_schools');
        if(!empty($_POST)) {
            $this->session->set('start_date', $_POST['startdate']);
            $this->session->set('end_date', $_POST['enddate']);
        } 
        
        $data['list'] = array();
        $list = $this->school->get_list(array('action'=>'download', 'pagecount'=>DOWNLOAD_LIMIT));
        foreach ($list as $row) {
            array_push($data['list'], array('School Name'=>$row['name'], 'Date Registered'=>$row['date_registered'], 'School Type'=>$row['school_type'], 'Address'=>$row['addressline'].' '.$row['county'].' '.$row['district'].' '.$row['country'], 'Email Address'=>$row['email_address'], 'Telephone'=>$row['telephone'] ));
        }
        
        $data['area'] = 'download_csv';
        echo view('page/download', $data);
    }
    
    
    
    
    # Verify the school before proceeding to the next stage
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a school
            $result = $this->school->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('approve'=>'approved', 'reject'=>'rejected', 'archive'=>'archived', 'restore'=>'restored');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            $this->session->set('msg', ($result['boolean']? "The school has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The school could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_school';
            echo view('addons/basic_addons', $data);
        }
    }
}

/* End of controller file */
