<?php

namespace App\Controllers;

/**
 * This class controls viewing user pages on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/20/2015
 */
use App\Models\_person;

class User extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->person = new _person();
    }
    
    
    
    # Add a new user
    public function add()
    {
        $data = filter_forwarded_data($this);
        if (!(!empty($data['action']) && $data['action'] == 'view' && !empty($data['id']))) {
            check_access($this, 'add_new_user');
        }
        # Remove any session variables if still in the session.
        $this->user->clear_session();
        
        # If user has posted the form for processing
        if (!empty($_POST)) {
            # Editing user
            if ($this->request->getPost('userid')) {
                $data['result'] = $this->user->updated($this->request->getPost('userid'), $this->request->getPost());
                
                $data['userid'] = $this->request->getPost('userid');
                $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "Your user details have been saved.": $data['result']['msg'];
                # Redirect to appropriate page if successful
                $this->session->set('msg', $data['msg']);
                $data['forward'] = base_url().$this->request->getPost('forward');
            }
            # New user
            else {
                #Pass these details to the person object to handle with XSS filter turned on
                $data['result'] = $this->person->add_profile($this->request->getPost());
                $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "The user account has been created.": $data['result']['msg'];
                if ($data['result']['boolean']) {
                    $this->session->remove(['person_id', 'firstname', 'lastname', 'role__roles', 'emailaddress', 'telephone']);
                    $this->session->set('msg', $data['msg']);
                    return redirect()->to('user/update_status');
                }
            }
        }
        
        #If editing, load the id details into the session for the first time
        if (!empty($data['id']) && empty($_POST)) {
            $this->user->populate_session($data['id'], (!empty($data['action'])? false: true));
        }
        echo view('user/new_user', $data);
    }
    
    
    # Set user permissions
    public function set_permissions()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'set_user_permissions');
        
        # User is setting the permission
        if (!empty($data['set_id'])) {
            $check = array_key_contains('userpermission_', $data);
            if ($check['boolean']) {
                $result = $this->user->change_role($data['set_id'], $data[$check['key']]);
                $data['msg'] = $result? 'User role updated': 'ERROR: User not updated.';
            } else {
                $data['msg'] = 'ERROR: User ID not resolved.';
            }
            $data['area'] = 'basic_msg';
            echo view('addons/basic_addons', $data);
        } else {
            $data['action'] = 'setpermission';
            $data['list'] = $this->user->get_list(array('action'=>'setpermission'));
            echo view('user/list_users', $data);
        }
    }
    
    
    
    # Update user status
    public function update_status()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'change_user_status');
        
        $data['action'] = 'update';
        $data['list'] = $this->user->get_list(array('action'=>'update'));
        echo view('user/list_users', $data);
    }
    
    
    # Change other users' passwords
    public function change_password()
    {
        $data = filter_forwarded_data($this);
        check_access($this, 'change_other_user_passwords');
        
        if (!empty($_POST)) {
            $check = array_key_contains('userpassword_', $_POST);
            if ($check['boolean']) {
                $result = $this->user->update_password($data['id'], $this->request->getPost($check['key']));
                $data['msg'] = $result? 'User password updated': 'ERROR: User password not updated.';
            } else {
                $data['msg'] = 'ERROR: User not resolved.';
            }
            $data['area'] = 'basic_msg';
            echo view('addons/basic_addons', $data);
        } else {
            $data['action'] = 'changepassword';
            $data['list'] = $this->user->get_list(array('action'=>'changepassword'));
            echo view('user/list_users', $data);
        }
    }
    
    
    # Verify the user (all actions: approve, reject, block, etc)
    public function verify()
    {
        $data = filter_forwarded_data($this);
        if (!empty($_POST)) {
            # Approve or reject a user
            $result = $this->user->verify($_POST);
            
            $actionPart = current(explode("_", $_POST['action']));
            $actions = array('approve'=>'approved', 'reject'=>'rejected', 'block'=>'blocked', 'archive'=>'archived', 'restore'=>'restored', 'publish'=>'published');
            $actionWord = !empty($actions[$actionPart])? $actions[$actionPart]: 'made';
            $this->session->set('msg', ($result['boolean']? "The user has been ".$actionWord: (!empty($result['msg'])? $result['msg']: "ERROR: The user could not be ".$actionWord)));
        } else {
            # Get list type
            $data['list_type'] = current(explode("_", $data['action']));
            $data['area'] = 'verify_user';
            echo view('addons/basic_addons', $data);
        }
    }
    
    
    
    
    
    # View a user list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        $instructions['action'] = array('report'=>'view_users');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->user->get_list(array('action'=>'report'));
        echo view('user/list_users', $data);
    }
    
    
    
    # Download the list
    public function download()
    {
        check_access($this, 'view_users');
        if(!empty($_POST)) {
            $this->session->set('start_date', $_POST['startdate']);
            $this->session->set('end_date', $_POST['enddate']);
        } 
        
        $data['list'] = array();
        $list = $this->user->get_list(array('action'=>'download', 'pagecount'=>DOWNLOAD_LIMIT));
        foreach ($list as $row) {
            array_push($data['list'], array('Name'=>$row['display'], 'Permission'=>$row['user_role'], 'Email Address'=>$row['email_address'], 'Telephone'=>$row['telephone'], 'Status'=>strtoupper($row['status']), 'Date Added'=>date('d-M-Y', strtotime($row['date_added'])) ));
        }
        
        $data['area'] = 'download_csv';
        echo view('page/download', $data);
    }
}

/* End of controller file */
