<?php

namespace App\Controllers;

/**
 * This class controls viewing approvals on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 02/28/2015
 */
use App\Models\_approval_chain;

class Approval extends BaseController
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->approval_chain = new _approval_chain();
    }
    
    
    # View a approval list
    public function lists()
    {
        $data = filter_forwarded_data($this);
        $instructions['action'] = array('report'=>'view_approval_chain');
        check_access($this, get_access_code($data, $instructions));
        
        $data['list'] = $this->approval_chain->get_list($data);
        echo view('approval/list_approvals', $data);
    }
}

/* End of controller file */
