<?php

namespace App\Controllers;

/**
 * This class controls acount registration on the system.
 *
 * @author Al Zziwa <azziwa@gmail.com>
 * @version 1.1.0
 * @copyright TMIS
 * @created 01/08/2015
 */

use App\Models\_teacher;
use App\Models\_document;
use App\Models\_person;

class Register extends BaseController
{
    # Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->teacher = new _teacher();
        $this->document = new _document();
        $this->person = new _person();
    }
    
    
    #The first step form for the registration process
    public function step_one()
    {
        $data = filter_forwarded_data($this);
        
        # Are you just editing the step for preview?
        if (!empty($data['action']) && $data['action'] == 'edit_preview') {
            $this->session->set('just_preview_1', 'Y');
        } elseif (!empty($data['action']) && $data['action'] == 'prefill') {
            $this->teacher->populate_session($this->session->get('__user_id'));
        }
        
        # The user posted the form
        if (!empty($_POST)) {
            #Pass these details to the person object to handle with XSS filter turned on
            $data['result'] = $this->person->add_profile($this->request->getPost());
            $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "Please check your email for a confirmation code to proceed.": $data['result']['msg'];
        }
        
        
        # Prepare appropriate message and view to load
        if (!empty($data['result']['boolean']) && $data['result']['boolean']) {
            if ($this->request->getPost('justpreview')) {
                $data['msg'] = "Your application had been saved. Click Submit to finish.";
                $this->session->remove('just_preview_1');
                $viewToLoad = 'register/step_four';
            } else {
                $viewToLoad = 'register/step_two';
            }
        } else {
            $viewToLoad = 'register/step_one';
        }
        
        echo view($viewToLoad, $data);
    }
    
    
    
    
    
    
    #The second step form for the registration process
    public function step_two()
    {
        $data = filter_forwarded_data($this);
        
        # Are you just editing the step for preview?
        if (!empty($data['action']) && $data['action'] == 'edit_preview') {
            $this->session->set('just_preview_2', 'Y');
        }
        
        # The user posted the form
        if (!empty($_POST)) {
            if ($this->session->get('person_id')) {
                #Pass these details to the person object to handle with XSS filter turned on
                $data['result'] = $this->person->add_id_and_contacts($this->session->get('person_id'), $this->request->getPost());
                $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "Please enter your education and qualifications to proceed.": $data['result']['msg'];
            } else {
                $data['msg'] = "ERROR: We could not verify your data. Your session may have expired. If this problem persists, please contact us.";
            }
        }
        
        # Prepare appropriate message and view to load
        if (!empty($data['result']['boolean']) && $data['result']['boolean']) {
            if ($this->request->getPost('justpreview')) {
                $data['msg'] = "Your application had been saved. Click Submit to finish.";
                $this->session->remove('just_preview_2');
                $viewToLoad = 'register/step_four';
            } elseif ($this->request->getPost('justsaving')) {
                $data['msg'] = "Your application had been saved. <br>You will need to login using the details sent to your email to proceed with your application.";
                $viewToLoad = 'account/login';
            } else {
                $viewToLoad = 'register/step_three';
            }
        } else {
            $viewToLoad = 'register/step_two';
        }
        
        echo view($viewToLoad, $data);
    }
    
    
    
    
    
    
    # The third step form for the registration process
    public function step_three()
    {
        $data = filter_forwarded_data($this);
        
        # Are you just editing the step for preview?
        if (!empty($data['action']) && $data['action'] == 'edit_preview') {
            $this->session->set('just_preview_3', 'Y');
        }
        
        # The user posted the form
        if (!empty($_POST)) {
            if ($this->session->get('person_id')) {
                # a) Are they adding an education?
                if (!empty($data['action']) && $data['action'] == 'add_education') {
                    $data['response'] = $this->person->add_education($this->session->get('person_id'), $this->request->getPost());
                    $data['area'] = "education_list";
                    $viewToLoad = "addons/basic_addons";
                }
            
                # b) Are they adding a subject?
                elseif (!empty($data['action']) && $data['action'] == 'add_subject') {
                    $data['response'] = $this->person->add_subject_taught($this->session->get('person_id'), $this->request->getPost());
                    $data['area'] = "subject_list";
                    $viewToLoad = "addons/basic_addons";
                }
            
                # c) Are they adding a document?
                elseif (!empty($data['action']) && $data['action'] == 'add_document') {
                    # Process the document addition if one has been successfully uploaded
                    if (!empty($_FILES['documenturl__fileurl']) && file_exists($_FILES['documenturl__fileurl']['tmp_name'])) {
                        $upload = $this->document->upload($_FILES['documenturl__fileurl'], array('type'=>'document'));
                        $_POST['documenturl__fileurl'] = $upload['file'];
                    }
                    $data['response'] = $this->person->add_document($this->session->get('person_id'), $this->request->getPost());
                    
                    $data['area'] = "document_list";
                    $viewToLoad = "addons/basic_addons";
                }
                
                # d) Are they submitting the entire form to save the data?
                elseif ($this->session->get('education_list') && $this->session->get('subject_list')) {
                    #Pass these details to the person object to handle with XSS filter turned on
                    $data['result'] = $this->person->add_education_and_qualifications($this->session->get('person_id'), $this->request->getPost());
                    $data['msg'] = $data['result']['boolean'] && empty($data['result']['msg'])? "Please review your details and submit.": $data['result']['msg'];
                }
                
                # d) Has the user submitted an incomplete form?
                else {
                    $data['result']['boolean'] = false;
                    $data['msg'] = "WARNING: You need to provide both the education and subjects studied to continue.";
                }
            } else {
                $data['msg'] = "ERROR: We could not verify your data. Your session may have expired. If this problem persists, please contact us.";
            }
        }
        
        
        if (!empty($data['result']['boolean']) && $data['result']['boolean']) {
            if ($this->request->getPost('justpreview')) {
                $data['msg'] = "Your application has been saved. Click Submit to finish.";
                $this->session->remove('just_preview_3');
                $viewToLoad = 'register/step_four';
            } elseif ($this->request->getPost('justsaving')) {
                $data['msg'] = "Your application had been saved. <br>You will need to login using the details sent to your email to proceed with your application.";
                $viewToLoad = 'account/login';
            } else {
                $viewToLoad = 'register/step_four';
            }
        }
        
        
        $viewToLoad = !empty($viewToLoad)? $viewToLoad: 'register/step_three';
        echo view($viewToLoad, $data);
    }
    
    
    
    
    # Function to edit a registration list item
    public function edit_list_item()
    {
        $data = filter_forwarded_data($this);
        
        # Populate the edit form if the necessary data is available
        if (!empty($data['type']) && !empty($data['item_id']) && $this->session->get($data['type'].'_list')) {
            $this->session->set('edit_step_3_'.$data['type'], 'Y');
            $data['details'] = get_row_from_list($this->session->get($data['type'].'_list'), $data['type'].'_id', $data['item_id']);
            $data['details']['item_id'] = $data['item_id'];
        }
        # Prepare appropriate message
        $data['msg'] = empty($data['details'])? "ERROR: We could not resolve the item you are attempting to edit.": "";
        
        $data['area'] = !empty($data['type'])? $data['type']."_form": "basic_msg";
        echo view('addons/basic_addons', $data);
    }
    
    
    
    
    # Function to delete a registration list item
    public function delete_list_item()
    {
        $data = filter_forwarded_data($this);
        
        if (!empty($data['type']) && !empty($data['item_id'])) {
            $result = $this->person->remove_list_item($data['type'], $data['item_id']);
        }
        
        $data['response']['msg'] = (!empty($result) && $result)? "The ".$data['type']." has been deleted.": "ERROR: There was a problem deleting the ".$data['type'].".";
        $data['area'] = !empty($data['type'])? $data['type']."_list": "basic_msg";
        echo view('addons/basic_addons', $data);
    }
    
    
    
    
    
    
    #The third step form for the registration process
    public function step_four()
    {
        $data = filter_forwarded_data($this);
        
        # The user posted the form
        if (!empty($_POST)) {
            $result = $this->person->submit_application($this->session->get('person_id'), array('user_id'=>($this->session->get('__user_id')? $this->session->get('__user_id'): $this->session->get('user_id')), 'emailaddress'=>$this->session->get('emailaddress'), 'first_name'=>$this->session->get('firstname'), 'last_name'=>$this->session->get('lastname')));
            if ($result['boolean']) {
                $data['msg'] = !empty($result['msg'])? $result['msg']: "Your application has been submitted. You will be notified using your registered email when it is approved.<br><br>Please check your email spam folder if you can not find your confirmation email.";
                $viewToLoad = 'account/login';
            } else {
                $data['msg'] = !empty($result['msg'])? $result['msg']: "ERROR: There was a problem submitting your application. Please try again or contact us if the problem persists.";
                $viewToLoad = 'register/step_four';
            }
        }
        
        
        /*
        Delete all session for current user so that you are able to register  multiple teachers
        @mover 11/11/2015
        */
        if (!empty($viewToLoad)) {
            $this->session->destroy();
        }
        
        
        $viewToLoad = !empty($viewToLoad)? $viewToLoad: 'register/step_four';
        echo view($viewToLoad, $data);
    }
}

/* End of controller file */
