<?php

namespace App\Models;

use CodeIgniter\Model;
use App\Models\_approval_chain;
use App\Models\_user;
use App\Models\_vacancy;
use App\Models\_permission;
use App\Models\_messenger;
use App\Models\_school;
use App\Models\_teacher;
use App\Models\_job;
use App\Models\_interview;
use App\Models\_confirmation;
use App\Models\_retirement;
use App\Models\_leave;
use App\Models\_transfer;
use App\Models\_report;
use App\Models\_census;

class _finder extends Model
{
    #Constructor to set some default values at class load
    public function __construct()
    {
        // parent::__construct();
        $this->approval_chain = new _approval_chain();
        $this->user = new _user();
        $this->vacancy = new _vacancy();
        $this->permission = new _permission();
        $this->messenger = new _messenger();
        $this->school = new _school();
        $this->census = new _census();
        $this->teacher = new _teacher();
        $this->job = new _job();
        $this->interview = new _interview();
        $this->confirmation = new _confirmation();
        $this->retirement = new _retirement();
        $this->leave = new _leave();
        $this->transfer = new _transfer();
        $this->report = new _report();
    }
    
    # Load a list of search items
    public function load_list($instructions)
    {
        $data = $instructions;
        $list = array();
        # Get the search parameters passed with the instructions
        $data['page'] = !empty($data['p']) && empty($data['__clear'])? $data['p']: 1;
        $data['pagecount'] = !empty($data['n']) && empty($data['__clear'])? $data['n']: NUM_OF_ROWS_PER_PAGE;
        $data['phrase'] = !empty($data['phrase']) && empty($data['__clear'])? addslashes(restore_bad_chars($data['phrase'])): '';
        $data['searchby'] = !empty($data['searchby']) && empty($data['__clear'])? explode('--', $data['searchby']): '';
        
        if (!empty($instructions['type'])) {
            $data['listid'] = $instructions['type'].'search';
            switch ($instructions['type']) {
                case 'user':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.first_name', 'P.last_name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->user->get_list($data);
                break;
                
                
                case 'vacancy':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('V.topic', 'V.summary', 'I.name');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->vacancy->get_list($data);
                break;
                
                
                case 'permission':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        # Default search fields
                        if (!empty($data['action']) && $data['action'] == 'grouplist') {
                            $default = array('notes');
                        } elseif (!empty($data['action']) && $data['action'] == 'userlist') {
                            $default = array('P.first_name', 'P.last_name','U.login_name' );
                        } else {
                            $default = array('display');
                        }
                        
                        $searchBy = !empty($data['searchby'])? $data['searchby']: $default;
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->permission->get_list($data);
                break;
                
                
                case 'message':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.first_name', 'P.last_name', 'M.subject');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->messenger->get_list($data);
                break;
                
                
                case 'school':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('S.name');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->school->get_list($data);
                break;
                
                
                case 'census':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.first_name', 'P.last_name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->census->get_list($data);
                break;
                
                
                case 'teacher':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $docFind = array('report','verify','approve','approve_pre_primary','verify_pre_primary','certify_pre_primary','confirm','certify');
                        if(in_array($data['action'], $docFind)) $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.first_name', 'P.last_name', 'd.tracking_number', 'P.nin','P.ipps','U.login_name' );
                        else $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.first_name', 'P.last_name', 'P.nin','P.ipps','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->teacher->get_list($data);
                break;
                
                
                case 'job':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('V.topic', 'V.summary', 'I.name');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->job->get_list($data);
                break;
                
                
                case 'interview':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        if (in_array($instructions['action'], array('setdate', 'recommend', 'recommendations'))) {
                            $default = array('V.topic', 'V.summary', 'I.name');
                        } elseif ($instructions['action'] == 'shortlist') {
                            $default = array('S.shortlist_name', 'V.topic', 'I.name' );
                        } else {
                            $default = array('P.first_name', 'P.last_name', 'V.topic','U.login_name' );
                        }
                        
                        $searchBy = !empty($data['searchby'])? $data['searchby']: $default;
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->interview->get_list($data);
                break;
                
                
                case 'confirmation':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P1.last_name', 'P1.first_name', 'D.name', 'I.name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->confirmation->get_list($data);
                break;
                
                
                case 'retirement':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.last_name', 'P.first_name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->retirement->get_list($data);
                break;
                
                
                case 'leave':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.last_name', 'P.first_name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->leave->get_list($data);
                break;
                
                
                case 'transfer':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.last_name', 'P.first_name', 'I.name','U.login_name' );
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->transfer->get_list($data);
                break;
                
                
                case 'report':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.last_name', 'P.first_name', 'L.details');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                        if (strpos($data['phrase'], '@') !== false) {
                            $data['searchstring'] = " (L.details LIKE '%email=".$data['phrase']."%|%' OR L.details LIKE '%username=".$data['phrase']."%|%') ";
                        }
                    }
                    $list = $this->report->get_list($data);
                break;
                
                
                case 'approval':
                    #Did the UI send any fields to search by?
                    if (empty($data['__clear'])) {
                        $searchBy = !empty($data['searchby'])? $data['searchby']: array('P.last_name', 'P.first_name', 'P.nin','P.ipps', 'A.chain_type');
                        $data['searchstring'] = $this->generate_phrase_query($searchBy, $data['phrase']);
                    }
                    $list = $this->approval_chain->get_list($data);
                break;
                
                
                
            }
        }
        $data['list'] = $list;
        return $data;
    }
        




    # Format the search query to be used in the search
    public function generate_phrase_query($searchBy, $phrase)
    {
        $query = array();
        $phrase = htmlentities($phrase, ENT_QUOTES);
        
        foreach ($searchBy as $field) {
            array_push($query, "(".$field." LIKE '".$phrase."%' OR ".$field." LIKE '% ".$phrase."%')");
        }
        
        return " (".implode(" OR ", $query).") ";
    }
}
