<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>

<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Forgot Password</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
	<link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

	<!-- Javascript -->
	
    <?php echo minify_js('account-recover_password', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"terms_of_use"));?>
    
    <div class="container-fluid mx-auto p-3 pt-5 p-md-5 m-0 app-area-page">
        <div class="forgot-area d-flex justify-content-center">
            <div class="forgot-area-wrap bg-white p-3 p-md-5 mt-5 border">
                <table class="microform vryform d-inline-block w-100" id="forgottable">
                    <tr class="d-inline-block mb-3">
                        <td class="h2 d-inline-block">Forgot Password</td>
                    </tr>
                    <tr class="d-inline-block">
                        <td class="d-inline-block mb-2">Your username is the same as your registered email address.</td>
                        <td class="d-inline-block mb-2">If your account was specially created by an administrator without using your email address, please <a href='<?php echo base_url();?>/Page/contact_us'>contact us</a> for a password recovery.</td>
                        <td class="d-inline-block">Otherwise, send yourself a temporary password using the form below.</td>
                    </tr>
                    <tr class="d-block mb-3">
                        <td>
                            <div id="forgotmsgdiv"></div>
                        </td>
                    </tr>
                    <tr class="d-block mb-3">
                        <td class="label text-start">Enter Your Registered Email Address</td>
                    </tr>
                    <tr class="d-block">
                        <td class="d-block">
                            <input type="text" id="registeredemail" name="registeredemail" class="textfield email d-block p-3 bg-light w-100" value="" maxlength="50" />
                        </td>
                    </tr>
                    <tr class="d-inline-block mt-5">
                        <td>
                            <button type="button" class="btn submitmicrobtn btn-primary" id="sendpassword" name="sendpassword">SEND MY TEMPORARY PASSWORD</button>
                            <input type="hidden" name="resultsdiv" id="resultsdiv" value="forgotmsgdiv">
                            <input type="hidden" name="action" id="action" value="<?php echo base_url();?>/account/forgot">
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <?php echo view("addons/public_footer");?>

</body>

</html>