<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Application List</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.shadowbox.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.pagination.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('application-list_applications', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js', 'tmis.list.js', 'bootstrap.min.js', 'tmis.shadowbox.js', 'tmis.pagination.js', 'tmis.search.js'));?>
</head>

<body>
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Application</h3>
                <div class="listsearchfield">
                    <input type="text"
                        id="applicationsearch__application" data-type="application"
                        name="applicationsearch__applications" placeholder="Search Applications"
                        class="findfield" value="" />
                    <input type='hidden' id='applicationsearch__displaydiv'
                        name='applicationsearch__displaydiv' value='applicationsearch__1' />
                    <input type='hidden' id='applicationsearch__action'
                        name='applicationsearch__action'
                        value='<?php echo base_url()."/Search/load_list/action/".(!empty($action)? $action: 'view');?>' />
                </div>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <div id="listcontainer">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td>
                                <div id="paginationdiv__applicationsearch_list">
                                    <div id="applicationsearch__1"><?php echo view('application/list', array(
                                    'listid'=>'applicationsearch',
                                    'list'=>(!empty($list)? $list: array()),
                                    'action'=>(!empty($action)? $action: ''),
                                    'msg'=>(!empty($msg)? $msg: '')
                                    ));?></div>
                                </div>
                            </td>
                        </tr>
                        <?php if (!empty($list)) {?>
                        <tr>
                            <td style="padding:40px 15px 10px 15px; ">
                                <div class='centerpagination'
                                    style="margin:0px;padding:0px;">
                                    <div id="applicationsearch"
                                        class="paginationdiv">
                                        <div class="previousbtn"
                                            style='display:none;'>&#x25c4;</div>
                                        <div class="selected">1</div>
                                        <div class="nextbtn">&#x25ba;</div>
                                    </div><input
                                        name="paginationdiv__applicationsearch_action"
                                        id="paginationdiv__applicationsearch_action"
                                        type="hidden"
                                        value="<?php echo base_url()."/Search/load_list/type/application/action/".(!empty($action)? $action: 'view');?>" />
                                    <input
                                        name="paginationdiv__applicationsearch_maxpages"
                                        id="paginationdiv__applicationsearch_maxpages"
                                        type="hidden"
                                        value="<?php echo NUM_OF_LISTS_PER_VIEW;?>" />
                                    <input
                                        name="paginationdiv__applicationsearch_noperlist"
                                        id="paginationdiv__applicationsearch_noperlist"
                                        type="hidden"
                                        value="<?php echo NUM_OF_ROWS_PER_PAGE;?>" />
                                    <input
                                        name="paginationdiv__applicationsearch_showdiv"
                                        id="paginationdiv__applicationsearch_showdiv"
                                        type="hidden"
                                        value="paginationdiv__applicationsearch_list" />
                                </div>
                            </td>
                        </tr>
                        <?php }?>
                    </table>
                </div>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>