<?php
$this->session = \Config\Services::session();
$forwardUrl = !empty($forward)? $forward: get_user_dashboard($this, $this->session->get('__user_id'));
?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>:
        <?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Reply To'): 'New';?> Message</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/trumbowyg.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ"
        crossorigin="anonymous"></script>
    <?php echo minify_js('message-new_message', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js', 'trumbowyg.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-JM8P0P17Z6');
var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }

    <?php echo !empty($id) && !empty($result['boolean']) && $result['boolean']?"window.top.location.href = '".$forwardUrl."';": "";?>
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()"
    onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header"); ?>

    <div id="messagehandler" style="display:none;"></div>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <?php
                                    
            echo !empty($msg)?"
                <tr>
                    <td>".format_notice($this, $msg)."</td>
                </tr>": "
            ";
            
            ?>

            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3><?php echo !empty($id)? (!empty($action) && $action=='view'? 'View':'Reply To'): 'New';?>Message
                </h3>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <table class='microform d-block w-100'>
                    <tr class="d-flex justify-content-start align-items-center my-3 border-bottom pb-2">
                        <td class="label d-block text-start p-0 me-2">Recipient:</td>
                        <td>

                            <?php
                        
                        if (!empty($id)) {
                            echo "<div class='value'>".$this->session->get('recipientname__users')."</div>";
                        } else {
                            # A non-admin user
                            if ($this->session->get('__permission_group') != '4') {
                                if ($this->session->get('recipientname__users')) {
                                    echo $this->session->get('recipientname__users')." <input type='hidden' id='recipientname__users' name='recipientname__users' value='".$this->session->get('recipientname__users')."' /> <input type='hidden' id='userid' name='userid' value='".$this->session->get('recipientid')."' />";
                                } else {
                                    echo "Website Administrator <input type='hidden' id='recipientname__users' name='recipientname__users' value='_all_admins_' /> <input type='hidden' id='userid' name='userid' value='_all_admins_' />";
                                }
                                    
                                # An admin user
                            } else {

                        ?>

                            <table>
                                <tr>
                                    <td>
                                        <input type="text" id="recipientname__users" name="recipientname__users"
                                            title="Select or Search for User" placeholder="Select or Search for User"
                                            class="textfield selectfield searchable"
                                            value="<?php echo $this->session->get('recipientname__users'); ?>" />
                                    </td>
                                    <td>
                                        <input type='checkbox' id='selectall' name='selectall' value='All'
                                            onClick="passFormValue('selectall', 'recipientname__users', 'checkbox');passFormValue('selectall', 'userid', 'checkbox');" /><label
                                            for='selectall' />Send to all</label><input type='text' class="textfield"
                                            id='userid' name='userid'
                                            value='<?php echo $this->session->get('recipientid'); ?>'
                                            style="display:none;" />
                                    </td>
                                </tr>
                            </table>
                            <?php }} ?>
                        </td>
                    </tr>

                    <?php if (!(!empty($action) && $action=='send_new_sms')) {?>

                    <tr class="d-block my-3">
                        <td class="label d-block me-2 text-start mb-2">Subject:</td>
                        <td class="w-100">
                            <?php
                        
                        if (!empty($id)) {
                            echo "<div class='value'>".$this->session->get('subject')."</div>";
                        } else {
                            
                        ?>

                            <input type="text" id="subject" name="subject" title="Subject" class="textfield"
                                value="<?php echo $this->session->get('subject');?>" /><?php }?>
                        </td>
                    </tr>

                    <?php }?>

                    <tr class="d-block my-3">
                        <td class="label d-block text-start p-0 me-2 mb-2">Message:</td>
                        <td class="d-block w-100">

                            <?php
                        
                        if (!empty($id)) {
                            echo "<div class='value'>".$this->session->get('message')."</div>";
                        } else {
                        
                        ?>
                            <textarea id="message" name="message" title="Message"
                                class="w-100 textfield <?php echo(!(!empty($action) && $action=='send_new_sms')? 'htmlfield': '');?>"
                                placeholder="Enter the message here."
                                style="min-width:300px; min-height: 300px;"><?php echo $this->session->get('message');?></textarea>

                            <?php }?>

                        </td>
                    </tr>

                    <?php if (!(!empty($action) && $action=='view')) { ?>

                    <tr class="d-flex justify-content-start align-items-start my-3">
                        <!-- <td>&nbsp;</td> -->
                        <td>
                            <button type="button" name="send" id="send"
                                class="btn btn-primary submitmicrobtn">SEND</button>
                            <input type='hidden' id='action' name='action'
                                value='<?php echo base_url().'/Message/'.(!empty($action)? $action: 'view'); ?>' />
                            <input type='hidden' id='tempmessage' name='tempmessage' value='Sending..' />
                            <input type='hidden' id='errormessage' name='errormessage'
                                value='You need to select a user and enter all fields to continue.' />
                            <input type='hidden' id='resultsdiv' name='resultsdiv' value='messagehandler' />
                        </td>
                    </tr>
                    <?php }?>
                </table>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

    <script type="text/javascript">
    $(function() {
        var btnsGrps = jQuery.trumbowyg.btnsGrps;
        $('.htmlfield').trumbowyg({
            btns: ['formatting',
                '|', btnsGrps.design,
                '|', 'link',
                '|', btnsGrps.justify,
                '|', 'insertHorizontalRule'
            ]
        });
    });
    </script>
</body>

</html>