<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Upgrade Certificate</title>
    <?php  $this->session = \Config\Services::session(); ?>
    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    </script>
    <?php echo minify_js('register-upgrade_certificate', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js','tmis.callout.js','tmis.fileform.js','tmis.menu.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Apply for Certificate Upgrade</h3>
                <?php
                        echo !empty($msg)?"<tr><td>".format_notice($this, $msg)."</td></tr>": "";
                        $msg = "";
                        ?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <form id="certificate_upgrade_form" method="post" autocomplete="off" action="<?php echo base_url();?>/Profile/upgrade_certificate" class='simplevalidator'>
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr class="d-block mb-3 border-bottom pb-2">
                            <td class="h4" style="">Education</td>
                        </tr>
                        <?php if (empty($preview)) {?>
                        <tr>
                            <td>
                                <div id="form_div__education" class='ignorearea'>
                                    <?php echo view('addons/basic_addons', array('area'=>'education_form'));?>
                                </div>
                            </td>
                        </tr>
                        <?php }?>

                        <tr class="d-block mt-3">
                            <td class="d-block">
                                <div id="institution_list">
                                    <?php
                                    if ($this->session->get('education_list')) {
                                     echo view('addons/basic_addons', array('area'=>'education_list', 'mode'=>(!empty($preview)? 'preview': '') ));
                                    } else {
                                    ?>
                                    <table border="0" cellspacing="0" cellpadding="0" class="resultslisttable d-block w-100">
                                        <tbody class="d-block w-100">
                                            <tr class="d-block w-100 border-bottom">
                                                <td class="h4 fst-normal fw-normal d-block w-100 border-0 p-0">Current List</td>
                                            </tr>
                                            <tr class="d-block w-100">
                                                <td class="border-0 p-0 pt-1">No education added yet.</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <?php } ?>
                                </div>
                            </td>
                        </tr>

                        <tr class="d-block mt-3">
                            <td class="h3">Qualification Documents</td>
                        </tr>

                        <?php if (empty($preview)) {?>
                        
                        <tr class="d-block mt-3">
                            <td>
                                <div id="form_div__document" class='ignorearea'>
                                    <?php echo view('addons/basic_addons', array('area'=>'document_form'));?>
                                </div>
                            </td>
                        </tr>
                        <?php }?>

                        <tr>
                            <td>
                                <div id="document_list">
                                    <?php
                                     if ($this->session->get('document_list')) {
                                         echo view('addons/basic_addons', array('area'=>'document_list', 'mode'=>(!empty($preview)? 'preview': '') ));
                                     } else {
                                         ?>
                                    <table border="0" cellspacing="0" cellpadding="0"
                                        class="resultslisttable">
                                        <tr>
                                            <td>Current List</td>
                                        </tr>
                                        <tr>
                                            <td>No document added yet.</td>
                                        </tr>
                                    </table>
                                    <?php } ?>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td>&nbsp;</td>
                        </tr>

                        <?php if (!(!empty($action) && $action=='view')) {?>
                        <tr>
                            <td>
                                <table width="100%" border="0" cellspacing="0" cellpadding="0"
                                    class='buttonnav'>
                                    <tr>
                                        <td><?php if (empty($id) && empty($upgrading_teacher)) {?><button
                                                type="button" name="canceladd" id="canceladd"
                                                class="greybtn"
                                                onclick="location.href='<?php echo base_url().'/Teacher/cancel/action/view';?>'">CANCEL</button><?php }?>
                                        </td>
                                        <td class='spacefiller'>&nbsp;</td>
                                        <?php if (!empty($preview)) {?>
                                        <td><button type="button" name="edit" id="edit" class="btn"
                                                onclick="location.href='<?php echo base_url().'/'.(!empty($upgrading_teacher)? 'Profile/upgrade_certificate/edit/Y': 'Teacher/add/edit/Y'.(!empty($id)? '/id/'.$id: ''));?>'">EDIT</button>
                                        </td>
                                        <td><?php echo !empty($id)? "<input type='hidden' id='userid' name='userid' value='".$id."'/>": ''; ?><input
                                                type="submit" name="upgrade" id="upgrade" value="APPLY"
                                                class="btn" /></td>
                                        <?php } else { ?>
                                        <td>&nbsp;</td>
                                        <td><input type="submit" name="preview" id="preview" value="PREVIEW"
                                                class="btn" /></td>

                                        <?php } ?>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <?php } ?>
                    </table>
                </form>
            </section>
        </main>
    </div>

    <?php echo view("addons/secure_footer");?>

</body>

</html>