<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: School List</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />

    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.shadowbox.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.pagination.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <script src="" integrity="sha384-kQtW33rZJAHjgefvhyyzcGF3C5TFyBQBA13V1RKPf4uH+bwyzQxZ6CmMZHmNBEfJ" crossorigin="anonymous"></script>
    <script type='text/javascript' src='<?php echo base_url();?>/assets/js/jquery-2.1.1.min.js'></script>
    <script type='text/javascript' src='<?php echo base_url();?>/assets/js/jquery-ui.js'></script>
    <script type='text/javascript' src='<?php echo base_url();?>/assets/js/jquery.form.js'></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.fileform.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.menu.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.responsive.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.list.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.shadowbox.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.pagination.js"></script>
    <script type="text/javascript" src="<?php echo base_url();?>/assets/js/tmis.search.js"></script>
    <script type="text/javascript">
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()" onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary d-none d-md-block">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content px-3 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Schools</h3>
                <?php if(check_access($this, 'add_new_school', 'boolean')) echo "<div class='nextdiv addcontenticon' data-url='school/add'></div>";?>
                <div class="listsearchfield">
                    <input type="text" id="schoolsearch__schools"
                        data-type="school" name="schoolsearch__schools"
                        placeholder="Search Schools" class="findfield" value="" />
                    <input type='hidden' id='schoolsearch__displaydiv'
                        name='schoolsearch__displaydiv' value='schoolsearch__1' />
                    <input type='hidden' id='schoolsearch__action' name='schoolsearch__action'
                        value='<?php echo base_url()."/Search/load_list/action/".(!empty($action)? $action: 'view');?>' />
                </div>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <div id="listcontainer">
                    <table width="100%" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td>
                                <div id="paginationdiv__schoolsearch_list">
                                    <div id="schoolsearch__1"><?php echo view('school/list', array(
                                    'listid'=>'schoolsearch',
                                    'list'=>(!empty($list)? $list: array()), 
                                    'action'=>(!empty($action)? $action: ''), 
                                    'msg'=>(!empty($msg)? $msg: '') 
                                    ));?></div>
                                </div>
                            </td>
                        </tr>
                        <?php if(!empty($list)){?>
                        <tr>
                            <td style="padding:40px 15px 10px 15px; ">
                                <div class='centerpagination'
                                    style="margin:0px;padding:0px;">
                                    <div id="schoolsearch" class="paginationdiv">
                                        <div class="previousbtn"
                                            style='display:none;'>&#x25c4;</div>
                                        <div class="selected">1</div>
                                        <div class="nextbtn">&#x25ba;</div>
                                    </div><input
                                        name="paginationdiv__schoolsearch_action"
                                        id="paginationdiv__schoolsearch_action"
                                        type="hidden"
                                        value="<?php echo base_url()."/Search/load_list/type/school/action/".(!empty($action)? $action: 'view');?>" />
                                    <input
                                        name="paginationdiv__schoolsearch_maxpages"
                                        id="paginationdiv__schoolsearch_maxpages"
                                        type="hidden" value="5" />
                                    <input
                                        name="paginationdiv__schoolsearch_noperlist"
                                        id="paginationdiv__schoolsearch_noperlist"
                                        type="hidden"
                                        value="<?php echo NUM_OF_ROWS_PER_PAGE;?>" />
                                    <input
                                        name="paginationdiv__schoolsearch_showdiv"
                                        id="paginationdiv__schoolsearch_showdiv"
                                        type="hidden"
                                        value="paginationdiv__schoolsearch_list" />
                                </div>
                            </td>
                        </tr>
                        <?php }?>
                    </table>
                </div>
            </section>
        </main>
    </div>
    
    <?php echo view("addons/secure_footer");?>

</body>

</html>