<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Login</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css" media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-uWxY/CJNBR+1zjPWmfnSnVxwRheevXITnMqoEIeG1LJrdI0GlVs/9cVSyPYXdcSF" crossorigin="anonymous">
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css">
	<link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    
    <?php echo minify_js('account-login', array('jquery-2.1.1.min.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.responsive.js'));?>
</head>

<body>
    <?php echo view("addons/public_header", array("page"=>"login"));?>
    <div class="container-fluid mx-auto mt-5 app-area-login py-3 bg-primary-light d-flex justify-content-center">
        <form id="tmislogin" method="post" autocomplete="off" class="my-md-5 border bg-white p-3 p-md-5 py-5 rounded">
            <div class="h2 m-0">Login</div>
            <table>
                <?php  echo !empty($msg)?"<tr class='my-3 d-inline-block mx-auto'><td class='d-inline-block mx-auto' >".format_notice($this,$msg)."</td></tr>": " ";  ?>

                <tr class="d-block mb-3">
                    <td class="label d-block text-start mb-1">Email Address</td>
                    <td class="d-block">
                        <input type="text" id="loginusername" name="loginusername" placeholder="Email Address" class="textfield d-block w-100 border bg-light p-3" value="" />
                    </td>
                    <td class="label d-block text-start mb-1">Password</td>
                    <td class="d-block">
                        <input type="password" id="loginpassword" name="loginpassword" placeholder="Password" class="textfield d-block w-100 bg-light p-3" value="" />
                    </td>
                    <td class="d-block mt-5">
                        <button type="button" class="greybtn btn btn-primary" id="submitlogin" name="submitlogin">LOGIN</button>
                    </td>
                    <td colspan="2" class="d-block">
                        <a href="<?php echo base_url().'/Account/forgot';?>" class="d-block">Forgot Username or Password?</a>
                        <a href="<?php echo base_url().'/Register/step_one';?>" class="d-block">Apply to Register as Teacher</a>
                    </td>
                </tr>
            </table>
        </form>
    </div>

    <?php echo view("addons/public_footer");?>

</body>

</html>