<?php $msg = empty($msg)? get_session_msg($this): $msg; ?>
<!DOCTYPE html>
<html>

<head>
    <meta content="text/html;charset=utf-8" http-equiv="Content-Type">
    <meta content="utf-8" http-equiv="encoding">
    <meta name="description" content="The Teacher Management Information System (TMIS) is a simple user-friendly approach to supporting a harmonized and timely access to teacher information and streamlining the delivery of government services to members of the teaching profession in Uganda.">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">
    <link rel="icon" href="<?php echo base_url();?>/favicon.ico" type="image/x-icon">

    <title><?php echo SITE_TITLE;?>: Custom Teacher Report</title>

    <!-- Stylesheets -->
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/jquery-ui.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.mobile.css" media="(max-width:790px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.tablet.css"
        media="(min-width:791px) and (max-width: 900px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.desktop.css" media="(min-width:901px)" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.list.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/tmis.menu.css" />
    <link rel="stylesheet" href="<?php echo base_url();?>/assets/css/updated.css" />

    <!-- Javascript -->
    <?php echo minify_js('teacher-custom_report', array('jquery-2.1.1.min.js', 'jquery-ui.js', 'jquery.form.js', 'tmis.js', 'tmis.fileform.js', 'tmis.menu.js', 'tmis.responsive.js'));?>
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-JM8P0P17Z6"></script>
    <script>
    window.dataLayer = window.dataLayer || [];

    function gtag() {
        dataLayer.push(arguments);
    }
    gtag('js', new Date());

    gtag('config', 'G-JM8P0P17Z6');
    var logout_timer = 0;

    function set_logout_interval() {
        // the interval 'timer' is set as soon as the page loads
        logout_timer = setInterval("auto_logout()", 600000);
        // the figure '600000' above indicates how many milliseconds (10 Minutes) the timer be set to.

    }

    function reset_logout_interval() {
        //After events on a page like click,scroll,page load, keystroke
        if (logout_timer != 0) {
            clearInterval(logout_timer);
            logout_timer = 0;
            // second step: implement the timer again
            logout_timer = setInterval("auto_logout()", 600000);
            // completed the reset of the timer
        }
    }

    function auto_logout() {

        // this function will redirect the user to the logout script
        window.location.href = "<?php echo base_url();?>/Account/logout";
    }
    </script>
</head>

<body onload="set_logout_interval()" onmousemove="reset_logout_interval()" onclick="reset_logout_interval()"
    onkeypress="reset_logout_interval()" onscroll="reset_logout_interval()" style="margin:0px;">
    <?php echo view("addons/secure_header");?>

    <div class="container-fluid mx-auto mt-5 pt-5 px-0 app-area">
        <aside class="app-area-sidebar px-3 py-4 bg-primary">
            <nav id="menucontainer" class="nav flex-column">
                <?php echo view("addons/menu");?>
            </nav>
        </aside>
        <main class="app-area-content p-3 pt-5 bg-light">
            <section class="d-flex justify-content-between align-items-center app-area-content-intro">
                <h3>Custom Teacher Report</h3>
                <?php echo !empty($msg)?"<tr><td>".format_notice($this,$msg)."</td></tr>": "";?>
            </section>
            <section class="app-area-content-body mt-3 px-3 py-3 bg-white">
                <table width='100%' cellpadding='5' class='microform ignoreclear d-block w-100'>
                    <tbody class="d-block w-100">
                        <tr class="d-block mt-1"></tr>
                        <tr class="d-block mt-1">
                            <td class='greybg smalltext p-1 px-2'>Select the report variables and click Generate to view
                                the report below.</td>
                        </tr>
                        <tr class="d-block w-100">
                            <td class="d-block w-100">
                                <div class='label text-start d-block mb-2'>Report Type</div>
                                <input type="text" id="reporttype__reporttypes" name="reporttype__reporttypes"
                                    title="Select Report Type" placeholder="Select Report Type"
                                    class="textfield selectfield d-block w-100" value="Number of Registered Teachers" />
                            </td>
                            <td class="d-block w-100">
                                <div class='label text-start mb-2'>Report Specification</div>
                                <div id='reportspecs'>
                                    <input type="text" id="reportsubtype__registerednumbers"
                                        name="reportsubtype__registerednumbers" title="Select Specification"
                                        placeholder="Select Specification" class="textfield selectfield d-block w-100"
                                        value="By Gender" />
                                </div>
                            </td>
                            <td class="d-block mt-3">
                                <button type='button' class='btn submitmicrobtn' name='generate' id='generate'
                                    value='GENERATE' style='width:110px;'>GENERATE</button>
                                <input type='hidden' id='action' name='action'
                                    value='<?php echo base_url()?>/Teacher/custom_report' />
                                <input type='hidden' id='resultsdiv' name='resultsdiv'
                                    value='customteacherreport_div' />
                                <input type='hidden' id='errormessage' name='errormessage'
                                    value='All fields are required to continue.' />
                            </td>

                        </tr>
                    </tbody>
                </table>
                <div id='customteacherreport_div'></div>
            </section>
        </main>
    </div>
    <?php echo view("addons/secure_footer");?>
</body>

</html>